/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.concurrent.Futures;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.Retryables;

public class EC2ImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final EC2Client ec2Client;
    private final ExecutorService executor;
    private final PredicateWithResult<String, Image> imageReadyPredicate;
    @Inject(optional=true)
    @Named(value="IMAGE_MAX_WAIT")
    private long maxWait = 3600L;
    @Inject(optional=true)
    @Named(value="IMAGE_WAIT_PERIOD")
    private long waitPeriod = 1L;

    @javax.inject.Inject
    public EC2ImageExtension(EC2Client ec2Client, @Named(value="jclouds.user-threads") ExecutorService userThreads, PredicateWithResult<String, Image> imageReadyPredicate) {
        this.ec2Client = Preconditions.checkNotNull(ec2Client);
        this.executor = Preconditions.checkNotNull(userThreads);
        this.imageReadyPredicate = imageReadyPredicate;
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        Reservation<? extends RunningInstance> instance = Iterables.getOnlyElement(this.ec2Client.getInstanceServices().describeInstancesInRegion(region, instanceId));
        if (instance == null) {
            throw new NoSuchElementException("Cannot find server with id: " + id);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    @Override
    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState(template instanceof CloneImageTemplate, " ec2 only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        String[] parts = AWSUtils.parseHandle(cloneTemplate.getSourceNodeId());
        final String region = parts[0];
        String instanceId = parts[1];
        final String imageId = this.ec2Client.getAMIServices().createImageInRegion(region, cloneTemplate.getName(), instanceId, CreateImageOptions.NONE);
        return Futures.makeListenable(this.executor.submit(new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                return (Image)Retryables.retryGettingResultOrFailing(EC2ImageExtension.this.imageReadyPredicate, region + "/" + imageId, EC2ImageExtension.this.maxWait, EC2ImageExtension.this.waitPeriod, TimeUnit.SECONDS, "Image was not created within the time limit, Giving up! [Limit: " + EC2ImageExtension.this.maxWait + " secs.]");
            }
        }), this.executor);
    }

    @Override
    public boolean deleteImage(String id) {
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        try {
            this.ec2Client.getAMIServices().deregisterImageInRegion(region, instanceId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

