/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class ImageImpl
extends ComputeMetadataImpl
implements Image {
    private static final long serialVersionUID = 7856744554191025307L;
    private final OperatingSystem operatingSystem;
    private final Image.Status status;
    private final String backendStatus;
    private final String version;
    private final String description;
    private final LoginCredentials defaultCredentials;

    public ImageImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, OperatingSystem operatingSystem, Image.Status status, @Nullable String backendStatus, String description, @Nullable String version, @Nullable LoginCredentials defaultCredentials) {
        super(ComputeType.IMAGE, providerId, name, id, location, uri, userMetadata, tags);
        this.operatingSystem = Preconditions.checkNotNull(operatingSystem, "operatingSystem");
        this.status = Preconditions.checkNotNull(status, "status");
        this.backendStatus = backendStatus;
        this.version = version;
        this.description = Preconditions.checkNotNull(description, "description");
        this.defaultCredentials = defaultCredentials;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Image.Status getStatus() {
        return this.status;
    }

    @Override
    public String getBackendStatus() {
        return this.backendStatus;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LoginCredentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    @Override
    @Deprecated
    public String getAdminPassword() {
        return this.defaultCredentials != null && this.defaultCredentials.shouldAuthenticateSudo() ? this.defaultCredentials.getPassword() : null;
    }

    @Override
    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper helper = this.computeToStringPrefix();
        helper.add("os", this.getOperatingSystem()).add("description", this.getDescription()).add("version", this.getVersion()).add("status", ComputeServiceUtils.formatStatus(this)).add("loginUser", this.defaultCredentials != null ? this.defaultCredentials.identity : null);
        return this.addComputeToStringSuffix(helper);
    }
}

