/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import org.jclouds.aws.ec2.domain.Tag;
import org.jclouds.aws.ec2.util.TagFilters;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.SAXException;

public class TagHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Tag> {
    private StringBuilder currentText = new StringBuilder();
    private String resourceId;
    private TagFilters.ResourceType resourceType;
    private String key;
    private String value;

    @Override
    public Tag getResult() {
        Tag returnVal = new Tag(this.resourceId, this.resourceType, this.key, this.value);
        return returnVal;
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (qName.equals("resourceId")) {
            this.resourceId = this.currentText.toString().trim();
        } else if (qName.equals("resourceType")) {
            this.resourceType = TagFilters.ResourceType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("key")) {
            this.key = this.currentText.toString().trim();
        } else if (qName.equals("value")) {
            this.value = this.currentText.toString().trim();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

