/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;

public abstract class BaseApiMetadata
implements ApiMetadata {
    private static final long serialVersionUID = -8080028444066498110L;
    protected final String id;
    protected final String name;
    protected final Set<TypeToken<? extends View>> views;
    protected final String endpointName;
    protected final String identityName;
    protected final Optional<String> credentialName;
    protected final String version;
    protected final Optional<String> buildVersion;
    protected final Optional<String> defaultEndpoint;
    protected final Optional<String> defaultIdentity;
    protected final Optional<String> defaultCredential;
    protected final Properties defaultProperties;
    protected final URI documentation;
    protected final TypeToken<? extends Context> context;
    protected final Set<Class<? extends Module>> defaultModules;

    public static Properties defaultProperties() {
        Properties props = new Properties();
        props.setProperty("jclouds.iso3166-codes", "");
        props.setProperty("jclouds.max-connections-per-context", "20");
        props.setProperty("jclouds.max-connections-per-host", "0");
        props.setProperty("jclouds.so-timeout", "60000");
        props.setProperty("jclouds.connection-timeout", "60000");
        props.setProperty("jclouds.io-worker-threads", "20");
        props.setProperty("jclouds.user-threads", "0");
        props.setProperty("jclouds.scheduler-threads", "10");
        props.setProperty("jclouds.max-connection-reuse", "75");
        props.setProperty("jclouds.max-session-failures", "2");
        props.setProperty("jclouds.session-interval", "60");
        props.setProperty("jclouds.payloads.pretty-print", "true");
        return props;
    }

    protected BaseApiMetadata(Builder builder) {
        this(builder.id, builder.name, builder.views, builder.endpointName, builder.identityName, builder.credentialName, builder.version, builder.buildVersion, builder.defaultEndpoint, builder.defaultIdentity, builder.defaultCredential, builder.defaultProperties, builder.documentation, builder.context, builder.defaultModules);
    }

    public BaseApiMetadata(String id, String name, Set<TypeToken<? extends View>> views, String endpointName, String identityName, Optional<String> credentialName, String version, Optional<String> buildVersion, Optional<String> defaultEndpoint, Optional<String> defaultIdentity, Optional<String> defaultCredential, Properties defaultProperties, URI documentation, TypeToken<? extends Context> context, Set<Class<? extends Module>> defaultModules) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.views = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(views, "views"));
        this.endpointName = Preconditions.checkNotNull(endpointName, "endpointName");
        this.identityName = Preconditions.checkNotNull(identityName, "identityName");
        this.credentialName = Preconditions.checkNotNull(credentialName, "credentialName");
        this.version = Preconditions.checkNotNull(version, "version");
        this.buildVersion = Preconditions.checkNotNull(buildVersion, "buildVersion");
        this.defaultEndpoint = Preconditions.checkNotNull(defaultEndpoint, "defaultEndpoint");
        this.defaultIdentity = Preconditions.checkNotNull(defaultIdentity, "defaultIdentity");
        this.defaultCredential = Preconditions.checkNotNull(defaultCredential, "defaultCredential");
        this.defaultProperties = Preconditions.checkNotNull(defaultProperties, "defaultProperties");
        this.documentation = Preconditions.checkNotNull(documentation, "documentation");
        this.context = Preconditions.checkNotNull(context, "context");
        this.defaultModules = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(defaultModules, "defaultModules"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApiMetadata)) {
            return false;
        }
        ApiMetadata that = (ApiMetadata)ApiMetadata.class.cast(o);
        return Objects.equal(this.getId(), that.getId()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getViews(), that.getViews());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId(), this.getName(), this.getViews());
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("id", this.getId()).add("name", this.getName()).add("views", this.getViews()).add("endpointName", this.getEndpointName()).add("identityName", this.getIdentityName()).add("credentialName", this.getCredentialName()).add("documentation", this.getDocumentation());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<TypeToken<? extends View>> getViews() {
        return this.views;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public String getIdentityName() {
        return this.identityName;
    }

    @Override
    public Optional<String> getCredentialName() {
        return this.credentialName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    public Optional<String> getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public Optional<String> getDefaultIdentity() {
        return this.defaultIdentity;
    }

    @Override
    public Optional<String> getDefaultCredential() {
        return this.defaultCredential;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public URI getDocumentation() {
        return this.documentation;
    }

    @Override
    public TypeToken<? extends Context> getContext() {
        return this.context;
    }

    @Override
    public Set<Class<? extends Module>> getDefaultModules() {
        return this.defaultModules;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public static class Builder
    implements ApiMetadata.Builder {
        protected String id;
        protected String name;
        protected Set<TypeToken<? extends View>> views = ImmutableSet.of();
        protected String endpointName = "https endpoint";
        protected String identityName;
        protected Optional<String> credentialName = Optional.absent();
        protected String version = "";
        protected Optional<String> buildVersion = Optional.of("");
        protected Optional<String> defaultEndpoint = Optional.absent();
        protected Optional<String> defaultIdentity = Optional.absent();
        protected Optional<String> defaultCredential = Optional.absent();
        protected Properties defaultProperties = BaseApiMetadata.defaultProperties();
        protected URI documentation;
        protected TypeToken<? extends Context> context = TypeToken.of(Context.class);
        protected Set<Class<? extends Module>> defaultModules = ImmutableSet.of();

        @Override
        public Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        @Override
        public Builder view(Class<? extends View> view) {
            return this.view((TypeToken)TypeToken.of(Preconditions.checkNotNull(view, "view")));
        }

        @Override
        public Builder view(TypeToken<? extends View> view) {
            return this.views(ImmutableSet.of(Preconditions.checkNotNull(view, "view")));
        }

        @Override
        public Builder views(Set<TypeToken<? extends View>> views) {
            this.views = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(views, "views"));
            return this;
        }

        @Override
        public Builder endpointName(String endpointName) {
            this.endpointName = Preconditions.checkNotNull(endpointName, "endpointName");
            return this;
        }

        @Override
        public Builder identityName(String identityName) {
            this.identityName = Preconditions.checkNotNull(identityName, "identityName");
            return this;
        }

        @Override
        public Builder credentialName(String credentialName) {
            this.credentialName = Optional.fromNullable(credentialName);
            return this;
        }

        @Override
        public Builder version(String version) {
            this.version = Preconditions.checkNotNull(version, "version");
            return this;
        }

        @Override
        public Builder buildVersion(String buildVersion) {
            this.buildVersion = Optional.fromNullable(buildVersion);
            return this;
        }

        @Override
        public Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = Optional.fromNullable(defaultEndpoint);
            return this;
        }

        @Override
        public Builder defaultIdentity(String defaultIdentity) {
            this.defaultIdentity = Optional.fromNullable(defaultIdentity);
            return this;
        }

        @Override
        public Builder defaultCredential(String defaultCredential) {
            this.defaultCredential = Optional.fromNullable(defaultCredential);
            return this;
        }

        @Override
        public Builder defaultProperties(Properties defaultProperties) {
            this.defaultProperties = Preconditions.checkNotNull(defaultProperties, "defaultProperties");
            return this;
        }

        @Override
        public Builder documentation(URI documentation) {
            this.documentation = Preconditions.checkNotNull(documentation, "documentation");
            return this;
        }

        @Override
        public Builder context(TypeToken<? extends Context> context) {
            this.context = Preconditions.checkNotNull(context, "context");
            return this;
        }

        @Override
        public Builder defaultModule(Class<? extends Module> defaultModule) {
            return this.defaultModules(ImmutableSet.of(Preconditions.checkNotNull(defaultModule, "defaultModule")));
        }

        @Override
        public Builder defaultModules(Set<Class<? extends Module>> defaultModules) {
            this.defaultModules = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(defaultModules, "defaultModules"));
            return this;
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            return ((Builder)((Builder)this.id(in.getId()).views((Set)in.getViews())).name(in.getName()).endpointName(in.getEndpointName()).identityName(in.getIdentityName()).credentialName(in.getCredentialName().orNull()).version(in.getVersion()).buildVersion(in.getBuildVersion().orNull()).defaultEndpoint(in.getDefaultEndpoint().orNull()).defaultIdentity(in.getDefaultIdentity().orNull()).defaultCredential(in.getDefaultCredential().orNull()).defaultProperties(in.getDefaultProperties()).documentation(in.getDocumentation()).context((TypeToken)in.getContext())).defaultModules((Set)in.getDefaultModules());
        }

        @Override
        public ApiMetadata build() {
            return new BaseApiMetadata(this){
                private static final long serialVersionUID = 3599854558038790678L;
            };
        }
    }
}

