/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.ci;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.HostParameters;
import com.xebialabs.deployit.plugin.cloud.ci.WaitForInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.ValidateDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import com.xebialabs.deployit.plugin.cloud.util.MarkerChecker;
import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.steps.CreateInstanceStep;
import com.xebialabs.deployit.plugin.ec2.steps.DestroyInstanceStep;
import com.xebialabs.deployit.plugin.ec2.util.EC2InstanceType;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

@Metadata(description="Amazon EC2 instance template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class HostTemplate
extends BaseHostTemplate {
    @Property(required=true, label="EC2 credentials", description="EC2 credentials to be used for creating instances from this template")
    private Credentials credentials;
    @Property(required=true, label="Groups", description="Set of security groups to be applied to the instance")
    private Set<String> groups;
    @Property(required=true, label="Image id (AMI)", description="Amazon Machine Image id")
    private String ami;
    @Property(required=true, label="Region", description="Amazon EC2 region to start instance in", defaultValue="eu-west-1")
    private String region;
    @Property(required=true, label="Instance type", description="Instance type which defines how much resources are allocated")
    private EC2InstanceType instanceType;
    @Property(required=true, label="Key pair", description="Name of the key pair (should be already present on EC2)")
    private String keyPair;

    @ControlTask(label="Instantiate", description="Create instance from template", parameterType="cloud.HostParameters")
    public List<? extends Step> instantiate(HostParameters params) {
        return Lists.newArrayList(new CreateInstanceStep(this, new EC2Adapter(this.credentials), params.getInstanceName()), new WaitForInstancesStep(new MarkerChecker()), new RegisterInstancesStep(new InstanceDescriptorResolver(), new CiParser(), params.getHostsLocation()));
    }

    @ControlTask(label="Validate descriptor", description="Validate XML descriptor")
    public List<? extends Step> validateDescriptor() {
        HashMap<String, Object> scope = Maps.newHashMap();
        scope.put("hostsPath", "Infrastructure/testHostsLocation");
        scope.put("hostTemplate", (Object)this);
        scope.put("cloudId", "myCloudId");
        scope.put("hostAddress", "localhost");
        return Lists.newArrayList(new ValidateDescriptorStep(new InstanceDescriptorResolver(), new CiParser(), scope, this.getXmlDescriptor()));
    }

    public EC2InstanceType getInstanceType() {
        return this.instanceType;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getAmi() {
        return this.ami;
    }

    public String getRegion() {
        return this.region;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setInstanceType(EC2InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public List<? extends Step> produceCreateSteps(String environmentTemplateName, int instanceSeq) {
        String instanceLabel = environmentTemplateName + " (" + this.getName() + ") #" + instanceSeq;
        return Arrays.asList(new CreateInstanceStep(this, new EC2Adapter(this.getCredentials()), instanceLabel));
    }

    public List<? extends Step> produceDestroySteps(ConfigurationItem instance) {
        return Arrays.asList(new DestroyInstanceStep(instance, new ServiceFactory()));
    }

    public String getInstanceIpAddress(String cloudId) {
        try {
            return new EC2Adapter(this.getCredentials()).waitUntilInstanceIsRunning(this.getRegion(), cloudId, this.getBootTimeout(), this.getRetryDelay());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

