package com.xebialabs.deployit.plugin.ec2.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import com.xebialabs.deployit.plugin.overthere.Host;

/**
 * Deletes instance from environment.
 * Should be used if instance is to be destroyed, but environment remains.
 */
@SuppressWarnings("serial")
public class UnregisterInstanceStep implements Step {

    private String instanceId;

    private String environmentId;

    public UnregisterInstanceStep(String instanceId) {
        this.instanceId = instanceId;
    }

    public UnregisterInstanceStep(final String instanceId, final String environmentId) {
        this.instanceId = instanceId;
        this.environmentId = environmentId;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Delete " + instanceId + " from repository";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        Host instance = ctx.getRepository().read(instanceId);

        if (environmentId != null) {
            ctx.logOutput("Removing instance from environment " + environmentId);
            Environment environment = ctx.getRepository().read(environmentId);

            environment.getLinkedCis().remove(instance);
            environment.getMembers().remove(instance);

            ctx.getRepository().update(environment);
        }

        ctx.logOutput("Deleting instance " + instanceId);
        ctx.getRepository().delete(instanceId);

        return StepExitCode.SUCCESS;
    }
}
