/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.converters;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.util.BitSet;
import java.util.StringTokenizer;
import org.nnsoft.guice.rocoto.converters.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSetConverter
extends AbstractConverter<BitSet> {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final int CHAR_LENGTH = 1;

    @Override
    public Object convert(String value, TypeLiteral<?> toType) {
        BitSet bitSet = new BitSet();
        int currentIndex = 0;
        StringTokenizer tokenizer = new StringTokenizer(value, DEFAULT_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken().trim();
            if (current.length() == 0) {
                throw new ProvisionException("Input '" + value + "' is not a valid java.util.BitSet, fragment at position " + currentIndex + " is empty");
            }
            if (1 == current.length() && !Character.isDigit(current.charAt(0))) {
                bitSet.set(current.charAt(0));
            } else {
                for (int i = 0; i < current.length(); ++i) {
                    if (Character.isDigit(current.charAt(i))) continue;
                    throw new ProvisionException("Input '" + value + "' is not a valid java.util.BitSet, fragment '" + current + "' at position " + currentIndex + " is not a valid integer");
                }
                bitSet.set(Integer.parseInt(current));
            }
            ++currentIndex;
        }
        return bitSet;
    }
}

