/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functionloader;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.functionloader.FunctionLoader;
import org.jclouds.scriptbuilder.functionloader.FunctionNotFoundException;
import org.jclouds.util.ClassLoadingUtils;

public enum BasicFunctionLoader implements FunctionLoader
{
    INSTANCE;


    @Override
    public String loadFunction(String function, OsFamily family) throws FunctionNotFoundException {
        try {
            return CharStreams.toString(Resources.newReaderSupplier(ClassLoadingUtils.loadResource(BasicFunctionLoader.class, String.format("/functions/%s.%s", function, ShellToken.SH.to(family))), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new FunctionNotFoundException(function, family, e);
        }
    }
}

