/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import com.google.common.base.Splitter;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.cim.xml.VirtualSystemSettingDataHandler;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VirtualHardwareSectionHandler
extends SectionHandler<VirtualHardwareSection, VirtualHardwareSection.Builder> {
    private final VirtualSystemSettingDataHandler systemHandler;
    private final ResourceAllocationSettingDataHandler allocationHandler;
    private boolean inItem;
    private boolean inSystem;

    @Inject
    public VirtualHardwareSectionHandler(Provider<VirtualHardwareSection.Builder> builderProvider, VirtualSystemSettingDataHandler systemHandler, ResourceAllocationSettingDataHandler allocationHandler) {
        super(builderProvider);
        this.systemHandler = systemHandler;
        this.allocationHandler = allocationHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "VirtualHardwareSection")) {
            if (attributes.containsKey("transport")) {
                ((VirtualHardwareSection.Builder)this.builder).transports(Splitter.on(' ').split(attributes.get("transport")));
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "System")) {
            this.inSystem = true;
        } else if (!this.inSystem && SaxUtils.equalsOrSuffix(qName, "Item")) {
            this.inItem = true;
        }
        if (this.inSystem) {
            this.systemHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inItem) {
            this.allocationHandler.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "System")) {
            this.inSystem = false;
            ((VirtualHardwareSection.Builder)this.builder).system(this.systemHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix(qName, "Item")) {
            this.inItem = false;
            ((VirtualHardwareSection.Builder)this.builder).item(this.allocationHandler.getResult());
        }
        if (this.inSystem) {
            this.systemHandler.endElement(uri, localName, qName);
        } else if (this.inItem) {
            this.allocationHandler.endElement(uri, localName, qName);
        } else {
            if (SaxUtils.equalsOrSuffix(qName, "Info")) {
                ((VirtualHardwareSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
            }
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inSystem) {
            this.systemHandler.characters(ch, start, length);
        } else if (this.inItem) {
            this.allocationHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }
}

