/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.Configuration;
import org.jclouds.ovf.Section;

public class DeploymentOptionSection
extends Section<DeploymentOptionSection> {
    protected final Set<Configuration> configurations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeploymentOptionSection.builder().fromDeploymentOptionSection(this);
    }

    public DeploymentOptionSection(String info, Iterable<Configuration> configurations) {
        super(info);
        this.configurations = ImmutableSet.copyOf(Preconditions.checkNotNull(configurations, "configurations"));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.configurations == null ? 0 : ((Object)this.configurations).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentOptionSection other = (DeploymentOptionSection)obj;
        return !(this.configurations == null ? other.configurations != null : !((Object)this.configurations).equals(other.configurations));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, configurations=%s]", this.info, this.configurations);
    }

    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public static class Builder
    extends Section.Builder<DeploymentOptionSection> {
        protected Set<Configuration> configurations = Sets.newLinkedHashSet();

        public Builder configuration(Configuration configuration) {
            this.configurations.add(Preconditions.checkNotNull(configuration, "configuration"));
            return this;
        }

        public Builder configurations(Iterable<Configuration> configurations) {
            this.configurations = ImmutableSet.copyOf(Preconditions.checkNotNull(configurations, "configurations"));
            return this;
        }

        public DeploymentOptionSection build() {
            return new DeploymentOptionSection(this.info, this.configurations);
        }

        public Builder fromDeploymentOptionSection(DeploymentOptionSection in) {
            return this.info(in.getInfo()).configurations(in.getConfigurations());
        }

        public Builder fromSection(Section<DeploymentOptionSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

