/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.annotations.Name;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.lifecycle.Closer;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.Utils;
import org.jclouds.rest.annotations.Identity;

@Singleton
public class ContextImpl
implements Context {
    private final ProviderMetadata providerMetadata;
    private final String identity;
    private final Utils utils;
    private final Closer closer;
    private final String name;

    @Inject
    protected ContextImpl(@Name String name, ProviderMetadata providerMetadata, @Identity String identity, Utils utils, Closer closer) {
        this.providerMetadata = Preconditions.checkNotNull(providerMetadata, "providerMetadata");
        this.identity = Preconditions.checkNotNull(identity, "identity");
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.closer = Preconditions.checkNotNull(closer, "closer");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.closer);
    }

    @Override
    public ProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public URI getEndpoint() {
        return URI.create(this.providerMetadata.getEndpoint());
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public String getApiVersion() {
        return this.providerMetadata.getApiMetadata().getVersion();
    }

    @Override
    public String getBuildVersion() {
        return this.providerMetadata.getApiMetadata().getBuildVersion().orNull();
    }

    public int hashCode() {
        return Objects.hashCode(this.providerMetadata, this.identity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextImpl that = (ContextImpl)ContextImpl.class.cast(obj);
        return Objects.equal(this.providerMetadata, that.providerMetadata) && Objects.equal(this.identity, that.identity);
    }

    public String toString() {
        return Objects.toStringHelper("").add("providerMetadata", this.providerMetadata).add("identity", this.identity).toString();
    }

    @Override
    public String getDescription() {
        return this.providerMetadata.getName();
    }

    @Override
    public String getId() {
        return this.providerMetadata.getId();
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.providerMetadata.getIso3166Codes();
    }

    @Override
    public Map<String, Object> getMetadata() {
        return ImmutableMap.of("endpoint", URI.create(this.providerMetadata.getEndpoint()), "apiVersion", this.providerMetadata.getApiMetadata().getVersion(), "buildVersion", this.providerMetadata.getApiMetadata().getBuildVersion().or(""), "identity", this.identity);
    }

    @Override
    public Location getParent() {
        return null;
    }

    @Override
    public LocationScope getScope() {
        return LocationScope.PROVIDER;
    }

    @Override
    public Map<String, Credentials> credentialStore() {
        return this.utils().credentialStore();
    }

    @Override
    public Map<String, Credentials> getCredentialStore() {
        return this.utils().credentialStore();
    }
}

