/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import org.jclouds.encryption.internal.Base64;
import org.jclouds.io.InputSuppliers;

@Beta
public class CryptoStreams {
    private static final char[] HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static char[] hex(byte[] in, int offset, int len) {
        char[] hex = new char[2 * len];
        int index = 0;
        for (int i = offset; i < offset + len; ++i) {
            byte b = in[i];
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return hex;
    }

    public static String hex(byte[] in) {
        return new String(CryptoStreams.hex(in, 0, in.length));
    }

    public static byte[] hex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String base64(byte[] in) {
        return Base64.encodeBytes(in, 8);
    }

    @Beta
    public static String base64Url(byte[] in) {
        String provisional = CryptoStreams.base64(in);
        int length = provisional.length();
        if (length == 0) {
            return provisional;
        }
        if (provisional.charAt(length - 2) == '=') {
            length -= 2;
        } else if (provisional.charAt(length - 1) == '=') {
            --length;
        }
        char[] tmp = new char[length];
        block4: for (int i = 0; i < length; ++i) {
            char c = provisional.charAt(i);
            switch (c) {
                case '+': {
                    tmp[i] = 45;
                    continue block4;
                }
                case '/': {
                    tmp[i] = 95;
                    continue block4;
                }
                default: {
                    tmp[i] = c;
                }
            }
        }
        return new String(tmp);
    }

    public static byte[] base64(String in) {
        return Base64.decode(in);
    }

    public static String md5Hex(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CryptoStreams.hex(CryptoStreams.md5(supplier));
    }

    public static String md5Hex(final String in) {
        try {
            return CryptoStreams.md5Hex((InputSupplier<? extends InputStream>)new InputSupplier<InputStream>(){

                @Override
                public InputStream getInput() throws IOException {
                    return new ByteArrayInputStream(in.getBytes());
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static String md5Base64(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CryptoStreams.base64(CryptoStreams.md5(supplier));
    }

    public static String macBase64(InputSupplier<? extends InputStream> supplier, Mac mac) throws IOException {
        return CryptoStreams.base64(CryptoStreams.mac(supplier, mac));
    }

    public static byte[] digest(InputSupplier<? extends InputStream> supplier, final MessageDigest md) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                md.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return md.digest();
            }
        });
    }

    public static byte[] sha1(InputSupplier<? extends InputStream> supplier) throws IOException {
        try {
            return CryptoStreams.digest(supplier, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate(e);
        }
    }

    public static byte[] sha1(byte[] in) {
        try {
            return CryptoStreams.sha1(ByteStreams.newInputStreamSupplier(in));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static byte[] md5(InputSupplier<? extends InputStream> supplier) throws IOException {
        try {
            return CryptoStreams.digest(supplier, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate(e);
        }
    }

    public static byte[] md5(byte[] in) {
        try {
            return CryptoStreams.md5(ByteStreams.newInputStreamSupplier(in));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static byte[] mac(InputSupplier<? extends InputStream> supplier, final Mac mac) throws IOException {
        return ByteStreams.readBytes(Preconditions.checkNotNull(supplier, "supplier"), new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                mac.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return mac.doFinal();
            }
        });
    }

    public static String base64Encode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(InputSuppliers.base64Encoder(supplier), new ByteProcessor<String>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                out.write(buf, off, len);
                return true;
            }

            @Override
            public String getResult() {
                return new String(out.toByteArray(), Charsets.UTF_8);
            }
        });
    }

    public static byte[] base64Decode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(InputSuppliers.base64Decoder(supplier), new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                out.write(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return out.toByteArray();
            }
        });
    }

    public static String hexEncode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final StringBuilder out = new StringBuilder();
        return ByteStreams.readBytes(supplier, new ByteProcessor<String>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                out.append(CryptoStreams.hex(buf, off, len));
                return true;
            }

            @Override
            public String getResult() {
                return out.toString();
            }
        });
    }

    public static byte[] hexDecode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){
            int currentPos = 0;

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                try {
                    if (this.currentPos == 0 && new String(Arrays.copyOfRange(buf, off, 2), "ASCII").equals("0x")) {
                        off += 2;
                    }
                    byte[] decoded = CryptoStreams.hex(new String(Arrays.copyOfRange(buf, off, len), "ASCII"));
                    out.write(decoded, 0, decoded.length);
                    this.currentPos += len;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("ASCII must be supported");
                }
                return true;
            }

            @Override
            public byte[] getResult() {
                return out.toByteArray();
            }
        });
    }
}

