/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class ReturnCredentialsBoundToImage
implements PopulateDefaultLoginCredentialsForImageStrategy {
    protected final LoginCredentials creds;
    protected final Map<String, Credentials> credentialStore;
    protected final Map<OsFamily, LoginCredentials> osFamilyToCredentials;

    @Inject
    public ReturnCredentialsBoundToImage(@Nullable @Named(value="image") LoginCredentials creds, Map<String, Credentials> credentialStore, Map<OsFamily, LoginCredentials> osFamilyToCredentials) {
        this.creds = creds;
        this.credentialStore = credentialStore;
        this.osFamilyToCredentials = osFamilyToCredentials;
    }

    @Override
    public LoginCredentials apply(Object resourceToAuthenticate) {
        Preconditions.checkState(resourceToAuthenticate instanceof Image, "this is only valid for images, not %s", resourceToAuthenticate.getClass().getSimpleName());
        if (this.creds != null) {
            return this.creds;
        }
        Image image = (Image)Image.class.cast(resourceToAuthenticate);
        if (this.credentialStore.containsKey("image#" + image.getId())) {
            return LoginCredentials.fromCredentials(this.credentialStore.get("image#" + image.getId()));
        }
        if (image.getOperatingSystem() != null && image.getOperatingSystem().getFamily() != null && this.osFamilyToCredentials.containsKey((Object)image.getOperatingSystem().getFamily())) {
            return this.osFamilyToCredentials.get((Object)image.getOperatingSystem().getFamily());
        }
        return LoginCredentials.builder().user("root").build();
    }

    public String toString() {
        return Objects.toStringHelper(this).toString();
    }
}

