/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.predicates.Validator;
import org.jclouds.predicates.validators.DnsNameValidator;

public class FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat
implements GroupNamingConvention {
    protected final String prefix;
    protected final char delimiter;
    protected final Supplier<String> suffixSupplier;
    protected final String sharedFormat;
    protected final String uniqueFormat;
    protected final Pattern uniqueGroupPattern;
    protected final Pattern sharedGroupPattern;
    protected final Validator<String> groupValidator;

    public FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat(String prefix, char delimiter, Supplier<String> suffixSupplier, Validator<String> groupValidator) {
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
        this.delimiter = delimiter;
        this.suffixSupplier = Preconditions.checkNotNull(suffixSupplier, "suffixSupplier");
        this.groupValidator = Preconditions.checkNotNull(groupValidator, "groupValidator");
        this.sharedFormat = "".equals(prefix) ? "%s" : prefix + delimiter + "%s";
        this.uniqueFormat = this.sharedFormat + delimiter + "%s";
        this.uniqueGroupPattern = Pattern.compile("^" + ("".equals(prefix) ? "" : prefix + delimiter) + "(.+)" + delimiter + "[^" + delimiter + "]+");
        this.sharedGroupPattern = Pattern.compile("^" + ("".equals(prefix) ? "" : prefix + delimiter) + "(.+)$");
    }

    @Override
    public String sharedNameForGroup(String group) {
        return String.format(this.sharedFormat, this.checkGroup(group));
    }

    protected String checkGroup(String group) {
        this.groupValidator.validate(Preconditions.checkNotNull(group, "group"));
        return group;
    }

    @Override
    public String uniqueNameForGroup(String group) {
        return String.format(this.uniqueFormat, this.checkGroup(group), this.suffixSupplier.get());
    }

    @Override
    public String groupInUniqueNameOrNull(String encoded) {
        return this.firstGroupInPatternOrNull(this.uniqueGroupPattern, encoded);
    }

    protected String firstGroupInPatternOrNull(Pattern pattern, String encoded) {
        Matcher matcher = pattern.matcher(Preconditions.checkNotNull(encoded, "encoded"));
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    @Override
    public String groupInSharedNameOrNull(String encoded) {
        return this.firstGroupInPatternOrNull(this.sharedGroupPattern, encoded);
    }

    @Override
    public Predicate<String> containsGroup(final String group) {
        this.checkGroup(group);
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                try {
                    return group.equals(FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat.this.groupInUniqueNameOrNull(input)) || group.equals(FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat.this.groupInSharedNameOrNull(input));
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String toString() {
                return "containsGroup(" + group + ")";
            }
        };
    }

    @Override
    public Predicate<String> containsAnyGroup() {
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                try {
                    return FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat.this.groupInUniqueNameOrNull(input) != null || FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat.this.groupInSharedNameOrNull(input) != null;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String toString() {
                return "containsAnyGroup()";
            }
        };
    }

    @Override
    public String extractGroup(String encoded) {
        String result = this.groupInUniqueNameOrNull(encoded);
        if (result != null) {
            return result;
        }
        result = this.groupInSharedNameOrNull(encoded);
        return result;
    }

    @Singleton
    public static class Factory
    implements GroupNamingConvention.Factory {
        @Inject(optional=true)
        @Named(value="jclouds.compute.resourcename-prefix")
        private String prefix = "jclouds";
        @Inject(optional=true)
        @Named(value="jclouds.compute.resourcename-delimiter")
        private char delimiter = (char)45;
        @Inject(optional=true)
        private Supplier<String> suffixSupplier = new Supplier<String>(){
            final SecureRandom random = new SecureRandom();

            @Override
            public String get() {
                return Integer.toHexString(this.random.nextInt(4095));
            }
        };
        @Inject(optional=true)
        private Validator<String> groupValidator = new DnsNameValidator(3, 63);
        LoadingCache<String, GroupNamingConvention> cache = CacheBuilder.newBuilder().build(new CacheLoader<String, GroupNamingConvention>(){

            @Override
            public GroupNamingConvention load(String key) throws Exception {
                return new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat(key, Factory.this.delimiter, Factory.this.suffixSupplier, Factory.this.groupValidator);
            }
        });

        @Override
        public GroupNamingConvention create() {
            return this.cache.getUnchecked(this.prefix);
        }

        @Override
        public GroupNamingConvention createWithoutPrefix() {
            return this.cache.getUnchecked("");
        }
    }
}

