/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.io.Serializable;
import java.util.Set;

public class TransformingSetSupplier<F, T>
implements Supplier<Set<? extends T>>,
Serializable {
    private static final long serialVersionUID = -8747953419394840218L;
    private final Supplier<Iterable<F>> backingSupplier;
    private final Function<F, T> converter;

    public TransformingSetSupplier(Supplier<Iterable<F>> backingSupplier, Function<F, T> converter) {
        this.backingSupplier = Preconditions.checkNotNull(backingSupplier, "backingSupplier");
        this.converter = Preconditions.checkNotNull(converter, "converter");
    }

    @Override
    public Set<? extends T> get() {
        Iterable<F> original = this.backingSupplier.get();
        return FluentIterable.from(original).filter(Predicates.notNull()).transform(this.converter).filter(Predicates.notNull()).toImmutableSet();
    }

    public int hashCode() {
        return Objects.hashCode(this.backingSupplier, this.converter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformingSetSupplier that = (TransformingSetSupplier)TransformingSetSupplier.class.cast(obj);
        return Objects.equal(this.backingSupplier, that.backingSupplier) && Objects.equal(this.converter, that.converter);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("backingSupplier", this.backingSupplier).add("converter", this.converter).toString();
    }
}

