/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.verification;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Verify(clazz=Verification.class, type="requiresProperties")
public @interface RequiresPropertyVerification {

    public static class Verification
    implements TypeVerification {
        public void verify(Descriptor descriptor, VerificationContext context) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().startsWith("requires") || propertyDescriptor.getKind() == PropertyKind.BOOLEAN) continue;
                context.error("Property [%s] is a release condition, but is not of type boolean", new Object[]{propertyDescriptor.getName()});
            }
        }
    }
}

