/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionVerifier {
    private static final Logger logger = LoggerFactory.getLogger(ConditionVerifier.class);

    public static VerificationResult validateReleaseConditions(Set<ReleaseCondition> conditions, Version deploymentPackage) {
        VerificationResult result = new VerificationResult();
        block4: for (ReleaseCondition condition : conditions) {
            if (!deploymentPackage.hasProperty(condition.getName())) {
                String environmentConditionName = condition.getName().replaceFirst("satisfies", "requires");
                throw new RuntimeException(String.format("Property '%s' is missing from the definition of udm.DeploymentPackage. It is required since udm.Environment has a corresponding property named '%s'", condition.getName(), environmentConditionName));
            }
            PropertyKind kind = Type.valueOf(DeploymentPackage.class).getDescriptor().getPropertyDescriptor(condition.getName()).getKind();
            Object value = deploymentPackage.getProperty(condition.getName());
            logger.debug("condition value for condition {} is {}", (Object)condition.getName(), value);
            switch (kind) {
                case BOOLEAN: {
                    ConditionVerifier.verifyBooleanCondition(condition.getLabel(), (Boolean)value, result);
                    continue block4;
                }
                case STRING: {
                    ConditionVerifier.verifyStringCondition(condition.getLabel(), (String)value, result);
                    continue block4;
                }
            }
            throw new IllegalArgumentException(String.format("Only release conditions of kind '%s' or '%s' are supported, but condition '%s' was of kind '%s'", PropertyKind.BOOLEAN, PropertyKind.STRING, kind));
        }
        return result;
    }

    private static void verifyBooleanCondition(String conditionName, Boolean conditionValue, VerificationResult result) {
        if (!Boolean.TRUE.equals(conditionValue)) {
            result.logViolatedCondition(conditionName, Boolean.TRUE, conditionValue);
        } else {
            result.logValidatedCondition(conditionName);
        }
    }

    private static void verifyStringCondition(String conditionName, String conditionValue, VerificationResult result) {
        if (ConditionVerifier.isNullOrBlank(conditionValue)) {
            result.logViolatedCondition(conditionName, "non-empty value", conditionValue);
        } else {
            result.logValidatedCondition(conditionName);
        }
    }

    private static boolean isNullOrBlank(String string) {
        return Strings.nullToEmpty((String)string).trim().isEmpty();
    }

    public static class ViolatedCondition<T> {
        public final String name;
        public final T expectedValue;
        public final T actualValue;

        private ViolatedCondition(String name, T expectedValue, T actualValue) {
            this.name = name;
            this.expectedValue = expectedValue;
            this.actualValue = actualValue;
        }
    }

    public static class VerificationResult {
        private final ImmutableSet.Builder<ViolatedCondition<?>> violatedConditions = new ImmutableSet.Builder();
        private final ImmutableSet.Builder<String> validatedConditions = new ImmutableSet.Builder();
        private boolean failed = false;

        private <T> void logViolatedCondition(String condition, T expectedValue, T actualValue) {
            this.violatedConditions.add(new ViolatedCondition(condition, expectedValue, actualValue));
            this.failed = true;
        }

        private void logValidatedCondition(String condition) {
            this.validatedConditions.add((Object)condition);
        }

        public boolean failed() {
            return this.failed;
        }

        public Set<ViolatedCondition<?>> getViolatedConditions() {
            return this.violatedConditions.build();
        }

        public Set<String> getValidatedConditions() {
            return this.validatedConditions.build();
        }
    }
}

