/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.planning;

import com.google.common.collect.ImmutableList;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.api.xld.Domain;
import com.xebialabs.deployit.plugins.releaseauth.ConditionVerifier;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;
import com.xebialabs.deployit.plugins.releaseauth.step.LogReleaseConditionsStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckReleaseConditionsAreMet {
    public static final String ENV_RELEASE_CONDITIONS_PROPERTY = "releaseConditions";
    private static final String ENV_RECHECK_CONDITIONS_PROPERTY = "recheckConditionsAtDeploymentTime";
    private static final String ENV_RECHECK_CONDITIONS_ORDER_PROPERTY = "recheckConditionsAtDeploymentTimeOrder";
    private static final List<Step> NO_STEPS = ImmutableList.of();
    private static final Logger logger = LoggerFactory.getLogger(CheckReleaseConditionsAreMet.class);

    @PrePlanProcessor
    public static List<Step> validate(DeltaSpecification spec) {
        AppliedDistribution deployedApplication = spec.getAppliedDistribution();
        Set<ReleaseCondition> conditions = CheckReleaseConditionsAreMet.getReleaseConditions(deployedApplication);
        if (conditions.isEmpty()) {
            return NO_STEPS;
        }
        ConditionVerifier.VerificationResult result = ConditionVerifier.validateReleaseConditions(conditions, deployedApplication.getVersion());
        if (result.failed()) {
            throw new IllegalArgumentException(CheckReleaseConditionsAreMet.buildErrorMessage(deployedApplication, result.getViolatedConditions()));
        }
        return CheckReleaseConditionsAreMet.createLogStep(deployedApplication, conditions);
    }

    private static List<Step> createLogStep(AppliedDistribution deployedApplication, Set<ReleaseCondition> conditions) {
        ImmutableList.Builder deploymentSteps = ImmutableList.builder();
        Domain environment = deployedApplication.getEnvironment();
        if (!environment.hasProperty(ENV_RECHECK_CONDITIONS_PROPERTY) || Boolean.TRUE.equals(environment.getProperty(ENV_RECHECK_CONDITIONS_PROPERTY))) {
            int order = environment.hasProperty(ENV_RECHECK_CONDITIONS_ORDER_PROPERTY) ? (Integer)environment.getProperty(ENV_RECHECK_CONDITIONS_ORDER_PROPERTY) : 0;
            logger.debug("Adding release auth condition check step at order {}", (Object)order);
            deploymentSteps.add((Object)new LogReleaseConditionsStep(order, conditions, deployedApplication.getVersion()));
        }
        return deploymentSteps.build();
    }

    private static Set<ReleaseCondition> getReleaseConditions(AppliedDistribution deployedApplication) {
        Domain environment = deployedApplication.getEnvironment();
        HashSet<ReleaseCondition> conditions = new HashSet<ReleaseCondition>();
        for (PropertyDescriptor property : environment.getType().getDescriptor().getPropertyDescriptors()) {
            Object value = property.get((ConfigurationItem)environment);
            if (!property.getName().startsWith("requires") || value == null || !((Boolean)value).booleanValue()) continue;
            ReleaseCondition condition = new ReleaseCondition(property.getName().replaceFirst("requires", "satisfies"), property.getLabel());
            conditions.add(condition);
        }
        return conditions;
    }

    private static String buildErrorMessage(AppliedDistribution deployedApplication, Set<ConditionVerifier.ViolatedCondition<?>> violatedConditions) {
        StringBuilder errorMessage = new StringBuilder().append("Cannot deploy '").append(deployedApplication.getName()).append("' (version ").append(deployedApplication.getVersion().getVersion()).append(") to '").append(deployedApplication.getEnvironment().getName()).append("' as the following release conditions are not met:");
        for (ConditionVerifier.ViolatedCondition<?> violatedCondition : violatedConditions) {
            errorMessage.append("\n- '").append(violatedCondition.name).append("'");
        }
        return errorMessage.toString();
    }
}

