package com.xebialabs.deployit.plugins.releaseauth.step;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;

import static java.lang.String.format;

@SuppressWarnings("serial")
public class LogReleaseConditionsStep implements Step {
    private final Set<ReleaseCondition> conditions;
    private Version deploymentPackage;
    private final int order;

    public LogReleaseConditionsStep(int order, Set<ReleaseCondition> conditions, Version deploymentPackage) {
        this.conditions = conditions;
        this.deploymentPackage = deploymentPackage;
        this.order = order;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput(" release conditions:");
        ctx.logOutput(buildValidatedConditionsMessage());
        return StepExitCode.SUCCESS;
    }

    private String buildValidatedConditionsMessage() {
        StringBuilder message = new StringBuilder();
        for (ReleaseCondition condition : conditions) {
            message.append(format("Condition '%s': OK%n", condition));
        }
        return message.toString();
    }

    @Override
    public String getDescription() {
        return format("Logging release authorization for deployment of '%s'", deploymentPackage);
    }

    @Override
    public int getOrder() {
        return order;
    }
}
