/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeployitEventListener
public class RepositoryCommandListener {
    public static final String ADMIN = "admin";
    public static final String VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE = "verifyChecklistPermissionsOnCreate";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryCommandListener.class);

    @Subscribe(canVeto=true)
    public void checkWhetherCreateIsAllowed(CreateCiCommand command) {
        if (this.checkCisNessessary(Lists.newArrayList((Object[])new ConfigurationItem[]{command.getCi()}))) {
            RepositoryCommandListener.checkCis(command.getCi(), RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(command.getCi())), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
        }
    }

    @Subscribe(canVeto=true)
    public void checkWhetherCreateIsAllowed(CreateCisCommand command) {
        if (this.checkCisNessessary(command.getCis())) {
            for (ConfigurationItem ci : command.getCis()) {
                RepositoryCommandListener.checkCis(ci, RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(ci)), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
            }
        }
    }

    @Subscribe(canVeto=true)
    public void checkWhetherUpdateIsAllowed(UpdateCiCommand command) {
        RepositoryCommandListener.checkCis(command.getUpdate().getNewCi(), RepositoryCommandListener.getChangedProperties(command.getUpdate(), RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(command.getUpdate().getNewCi()))), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
    }

    @Subscribe(canVeto=true)
    public void checkWhetherUpdateIsAllowed(UpdateCisCommand command) {
        for (Update update : command.getUpdates()) {
            RepositoryCommandListener.checkCis(update.getNewCi(), RepositoryCommandListener.getChangedProperties(update, RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(update.getNewCi()))), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
        }
    }

    private static void checkCis(ConfigurationItem newCi, Supplier<Stream<PropertyDescriptor>> changed, Set<String> roles, String username) {
        Supplier<Stream<PropertyDescriptor>> propertiesWithRolesLimitations;
        if (!newCi.getType().isSubTypeOf(Type.valueOf(Version.class))) {
            return;
        }
        Descriptor descriptor = newCi.getType().getDescriptor();
        Supplier<Stream<PropertyDescriptor>> noPermission = RepositoryCommandListener.getNoPermission(newCi, roles, username, descriptor, propertiesWithRolesLimitations = RepositoryCommandListener.getPropertiesWithRolesLimitations(newCi, changed));
        if (noPermission.get().findAny().isPresent()) {
            logger.error("User [{}] tried to update release conditions {} but didn't have permission for {} on ci {}", new Object[]{username, changed, noPermission, newCi.getId()});
            throw new CannotSetReleaseConditionsException(RepositoryCommandListener.getPropertyNames(noPermission.get()), newCi);
        }
        if (changed.get().findAny().isPresent()) {
            logger.info("User [{}] has updated release conditions {} on ci {}", new Object[]{username, changed, newCi.getId()});
        }
    }

    private static List<String> getPropertyNames(Stream<PropertyDescriptor> satisfiesForWhichUserHasNoPermission) {
        return satisfiesForWhichUserHasNoPermission.map(PropertyDescriptor::getName).collect(Collectors.toList());
    }

    private static Supplier<Stream<PropertyDescriptor>> getNoPermission(ConfigurationItem ci, Set<String> roles, String username, Descriptor descriptor, Supplier<Stream<PropertyDescriptor>> properties) {
        return () -> ((Stream)properties.get()).filter(propertyDescriptor -> {
            PropertyDescriptor roleProperty = descriptor.getPropertyDescriptor(RepositoryCommandListener.getRolePropertyName(propertyDescriptor));
            Set requiredRoles = (Set)roleProperty.get(ci);
            return !username.equals(ADMIN) && Sets.intersection((Set)roles, (Set)Sets.newHashSet((Iterable)requiredRoles)).isEmpty();
        });
    }

    private static Supplier<Stream<PropertyDescriptor>> getPropertiesWithRolesLimitations(ConfigurationItem ci, Supplier<Stream<PropertyDescriptor>> properties) {
        return () -> ((Stream)properties.get()).filter(propertyDescriptor -> ci.hasProperty(RepositoryCommandListener.getRolePropertyName(propertyDescriptor)));
    }

    private static Supplier<Stream<PropertyDescriptor>> getChangedProperties(Update update, Supplier<Stream<PropertyDescriptor>> properties) {
        return () -> ((Stream)properties.get()).filter(input -> update.getPreviousCi() == null || !input.areEqual(update.getPreviousCi(), update.getNewCi()));
    }

    private static Supplier<Stream<PropertyDescriptor>> getSatisfactionProperties(Collection<PropertyDescriptor> properties) {
        return () -> properties.stream().filter(input -> input.getName().startsWith("satisfies"));
    }

    private static String getRolePropertyName(PropertyDescriptor property) {
        String propName = property.getName().substring("satisfies".length());
        return "roles" + propName;
    }

    private Collection<PropertyDescriptor> getPropertyDescriptors(ConfigurationItem ci) {
        Descriptor descriptor = ci.getType().getDescriptor();
        return descriptor.getPropertyDescriptors();
    }

    private boolean checkCisNessessary(List<ConfigurationItem> cis) {
        Application application;
        Version version = cis.stream().filter(input -> input.getType().instanceOf(Type.valueOf(Version.class))).findFirst().orElse(null);
        if (version != null && (application = version.getApplication()) != null && application.hasProperty(VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE)) {
            return (Boolean)application.getProperty(VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE);
        }
        return false;
    }

    @HttpResponseCodeResult(statusCode=403)
    public static class CannotSetReleaseConditionsException
    extends DeployitException {
        private CannotSetReleaseConditionsException(List<String> properties, ConfigurationItem ci) {
            super("You are not authorized to set release conditions %s on %s", new Object[]{properties, ci});
        }
    }
}

