/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class PassThroughCapturingCommandExecutionCallbackHandler
implements CommandExecutionCallbackHandler {
    private CommandExecutionCallbackHandler originalHandler;
    private List<String> outputLines = new ArrayList<String>();
    private List<String> errorLines = new ArrayList<String>();
    private List<String> allLines = new ArrayList<String>();
    private boolean debug;

    public PassThroughCapturingCommandExecutionCallbackHandler(CommandExecutionCallbackHandler originalHandler) {
        this(originalHandler, false);
    }

    public PassThroughCapturingCommandExecutionCallbackHandler(CommandExecutionCallbackHandler originalHandler, boolean debug) {
        this.originalHandler = originalHandler;
        this.debug = debug;
    }

    public void handleOutputLine(String line) {
        if (this.debug) {
            System.out.println(line);
        }
        this.outputLines.add(line);
        this.allLines.add(line);
        this.originalHandler.handleOutputLine(line);
    }

    public void handleErrorLine(String line) {
        if (this.debug) {
            System.err.println(line);
        }
        this.errorLines.add(line);
        this.allLines.add(line);
        this.originalHandler.handleErrorLine(line);
    }

    public void handleOutput(char c) {
        this.originalHandler.handleOutput(c);
    }

    public List<String> getOutputLines() {
        return Collections.unmodifiableList(this.outputLines);
    }

    public String getOutput() {
        return StringUtils.join(this.outputLines, (String)"\n");
    }

    public List<String> getErrorLines() {
        return Collections.unmodifiableList(this.errorLines);
    }

    public String getError() {
        return StringUtils.join(this.errorLines, (String)"\n");
    }

    public List<String> getAllLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public String getAll() {
        return StringUtils.join(this.allLines, (String)"\n");
    }

    public String toString() {
        return this.getClass().getName() + "[output=\"" + this.getOutput() + "\", error=\"" + this.getError() + "\"]";
    }
}

