# [DEPL-8832] This script adds stop and start steps for application if Application is in NOOP and related Assemblies are Modified
from sets import Set
from com.xebialabs.deployit.plugin.api.reflect import Type
from biztalk.modules.biztalk_helper import BiztalkHelper

helper = BiztalkHelper(context, steps)

is_assembly_modified = False
noop_application_dict = dict()
impacted_application_set = Set()
for delta in deltas.deltas:
    deployed = delta.deployedOrPrevious
    if deployed.type == "biztalk.Application" and delta.operation == "NOOP":
        noop_application_dict[helper.get_application_name(deployed)] = deployed
    if delta.operation == "MODIFY" and deployed.type.isSubTypeOf(Type.valueOf('biztalk.BaseAssembly')):
        is_assembly_modified = True
        impacted_application_set.add(deployed.applicationName)

if is_assembly_modified:
    helper.add_application_stop_start_step_if_applicable(noop_application_dict, impacted_application_set)
