Function LoadBizTalkSnapIn() {
    Write-Host "Loading BizTalk Snap-In"
    $InitializeDefaultBTSDrive = $false
    Add-PSSnapin -Name BizTalkFactory.PowerShell.Extensions
}

Function ConnectToBizTalkDatabase($bizTalkServer) {
    LoadBizTalkSnapIn

    Write-Host "Connecting to BizTalk database [$($bizTalkServer.databaseName)] on [$($bizTalkServer.instanceName)]"
    if(!(Test-Path BizTalk4Deployit:\)){
        New-PSDrive -Name "BizTalk4Deployit" -PSProvider BizTalk -Root "BizTalk4Deployit:\" -Instance $bizTalkServer.instanceName -Database $bizTalkServer.databaseName -Scope Script | Out-Null
    }
}

Function ConnectToBizTalkDatabaseCatalog($bizTalkServer) {
    Write-Host "Connecting to BizTalk database [$($bizTalkServer.databaseName)] on [$($bizTalkServer.instanceName)]"
    # Do not remove the assignment below. See https://technet.microsoft.com/en-us/library/hh847760.aspx for more information on PowerShell return semantics
    $unused = [void] [System.reflection.Assembly]::LoadWithPartialName("Microsoft.BizTalk.ExplorerOM")
    $catalog = New-Object Microsoft.BizTalk.ExplorerOM.BtsCatalogExplorer
    $catalog.ConnectionString = "SERVER=$($bizTalkServer.instanceName);DATABASE=$($bizTalkServer.databaseName);Integrated Security=SSPI"
    $catalog
}
