class BiztalkHelper(object):
    def __init__(self, context, steps):
        self.context = context
        self.steps = steps

    def get_application_name(self, deployed):
        if deployed.applicationName:
            return deployed.applicationName
        else:
            return deployed.name

    def add_create_binding_step(self, bindings_set):
        for deployed in bindings_set:
            self.context.addStep(self.steps.powershell(
                    description="Import %s on %s" % (deployed.name, deployed.container.name),
                    order=deployed.createOrder,
                    script=deployed.createScript,
                    target_host=deployed.container,
                    powershell_context={"deployed": deployed}
            ))

    def add_application_stop_start_step_if_applicable(self, application_dict, application_set):
        for app_name in application_set:
            if app_name in application_dict:
                app_deployed = application_dict[app_name]
                self._add_stop_step(app_deployed)
                self._add_start_step(app_deployed)

    def _add_stop_step(self, deployed):
        self.context.addStep(self.steps.powershell(
                description="Stop %s on %s" % (deployed.name, deployed.container.name),
                order=deployed.stopOrder,
                script=deployed.stopScript,
                target_host=deployed.container,
                powershell_context={"deployed": deployed}
        ))

    def _add_start_step(self, deployed):
        self.context.addStep(self.steps.powershell(
                description="Start %s on %s" % (deployed.name, deployed.container.name),
                order=deployed.startOrder,
                script=deployed.startScript,
                target_host=deployed.container,
                powershell_context={"deployed": deployed}
        ))
