$catalog = ConnectToBizTalkDatabaseCatalog $deployed.container
$rdd = $catalog.RuledeploymentDriver
$rs = $rdd.getRuleStore()

$vocabularyName = if($deployed.vocabularyName) { $deployed.vocabularyName } else { $deployed.name }
$vocabularyInfo = New-Object -TypeName Microsoft.RuleEngine.VocabularyInfo -ArgumentList($vocabularyName, $deployed.majorVersion, $deployed.minorVersion)

if(!($rs.GetVocabulary($vocabularyInfo))) {
    Write-Host "Cannot delete version [$($deployed.majorVersion).$($deployed.minorVersion)] of vocabulary [$vocabularyName] because it does not exist. Did you specify the correct name/vocabularyName, majorVersion and minorVersion in the package?"
    Exit 1
}

Write-Host "Deleting version [$($deployed.majorVersion).$($deployed.minorVersion)] of vocabulary [$vocabularyName]"
$rs.Remove($vocabularyInfo)
