ConnectToBizTalkDatabase $deployed.container

$applicationName = if($deployed.applicationName) { $deployed.applicationName } else { $deployed.name }
$applicationReferences = $deployed.applicationReferences

cd "BizTalk4Deployit:\Applications"

If (!(Test-Path $applicationName)) { 
	Write-Host "Creating BizTalk application [$applicationName]"
	$application = New-Item -Path $applicationName
} else {
	Write-Host "Modifying BizTalk application [$applicationName]"
	$application = Get-Item -Path $applicationName
	
	$references = Get-ChildItem "$applicationName\References"

	foreach($r in $references) {
		if($r.Name -ne "BizTalk.System") {
			Write-Host "Removing application reference [$($r.Name)]"
			Remove-ApplicationReference -Path $applicationName -Reference $r.Name
		}
	}
}

if ($applicationReferences.count -gt 0) {
	Write-Host "Adding application reference(s) [$($deployed.applicationReferences)] for application [$applicationName] "
	Add-ApplicationReference -Path $applicationName -References $deployed.applicationReferences
}
