If ($deployed.sourcePath) {
    Write-Host "Copying assembly file to source path [$($deployed.sourcePath)]"
    New-Item -Force -ItemType File -Path $deployed.sourcePath | Out-Null
    Copy-Item -Force $deployed.file $deployed.sourcePath | Out-Null
}

If ($deployed.destinationPath -ne $deployed.sourcePath) {
    Write-Host "Copying assembly file to destination path [$($deployed.destinationPath)]"
    New-Item -Force -ItemType File -Path $deployed.destinationPath | Out-Null
    Copy-Item -Force $deployed.file $deployed.destinationPath | Out-Null
}

Write-Host "Loading EnterpriseServices"
$enterpriseServices = [System.Reflection.Assembly]::Load('System.EnterpriseServices, Version=2.0.0.0, Culture=neutral,  PublicKeyToken=b03f5f7f11d50a3a')
$publish = New-Object System.EnterpriseServices.Internal.Publish

Write-Host "Installing assembly [$((Get-ChildItem $deployed.file | Select Name).Name)] into global assembly cache"
$publish.GacInstall($deployed.file)
