ConnectToBizTalkDatabase $deployed.container

If ($deployed.sourcePath) {
    Write-Host "Copying assembly file to source path [$($deployed.sourcePath)]"
    New-Item -Force -ItemType File -Path $deployed.sourcePath | Out-Null
    Copy-Item -Force $deployed.file $deployed.sourcePath | Out-Null
    $sourcePath = $deployed.sourcePath
} Else {
    $sourcePath = $deployed.file
}

If ($deployed.destinationPath -ne $deployed.sourcePath) {
    Write-Host "Copying assembly file to destination path [$($deployed.destinationPath)]"
    New-Item -Force -ItemType File -Path $deployed.destinationPath | Out-Null
    Copy-Item -Force $deployed.file $deployed.destinationPath | Out-Null
}

Write-Host "Adding assembly [$($deployed.name)] to BizTalk application [$($deployed.applicationName)]"
cd "BizTalk4Deployit:\Applications\$($deployed.applicationName)\Resources"
$params = @{ Path=$deployed.name; ItemType=$deployed.assemblyType; Source=$sourcePath; DestinationLocation=$deployed.destinationPath }
if($deployed.gacOnAdd) {
    $params.GacOnAdd = $True
}
if($deployed.gacOnImport) {
    $params.GacOnImport = $True
}
if($deployed.gacOnInstall) {
    $params.GacOnInstall = $True
}
if($deployed.overwrite) {
    $params.Overwrite = $True
}
if($deployed.regAsm) {
    $params.Regasm = $True
}
if($deployed.regSvcs) {
    $params.Regsvcs = $True
}
New-Item @params | Out-Null
