$catalog = ConnectToBizTalkDatabaseCatalog $deployed.container
$rdd = $catalog.RuledeploymentDriver
$rs = $rdd.getRuleStore()

$rulesName = if($deployed.rulesName) { $deployed.rulesName } else { $deployed.name }
$ruleSetInfo = New-Object -TypeName Microsoft.RuleEngine.RuleSetInfo -ArgumentList($rulesName, $deployed.majorVersion, $deployed.minorVersion)

Write-Host "Importing and publishing rules [$rulesName]"
$rdd.ImportAndPublishFileRuleStore($deployed.file)

if(!($rs.GetRuleSet($ruleSetInfo))) {
    Write-Host "Cannot deploy version [$($deployed.majorVersion).$($deployed.minorVersion)] of rules [$rulesName] because it does not exist. Did you specify the correct name/rulesName, majorVersion and minorVersion in the package?"
    Exit 1
}

Write-Host "Deploying version [$($deployed.majorVersion).$($deployed.minorVersion)] of rules [$rulesName]"
$rdd.Deploy($ruleSetInfo)
