ConnectToBizTalkDatabase $deployed.container

cd "BizTalk4Deployit:\Applications\$($deployed.applicationName)\Resources"

Write-Output "Retrieving full name for assembly [$($deployed.name)]"
$assemblyName = [System.Reflection.AssemblyName]::GetAssemblyName($deployed.file).FullName

If (!(Test-Path $assemblyName)) {
    Write-Output "Assembly [$assemblyName] has already been removed."
    Exit 1
}

Write-Output "Removing assembly [$assemblyName] from BizTalk application [$($deployed.applicationName)]"
Remove-Item -Path $assemblyName
if(!$?) {
    Write-Output "Cannot remove assembly [$assemblyName] from BizTalk application [$($deployed.applicationName)]"
    Exit 1
}

If ($deployed.sourcePath) {
    Write-Output "Removing assembly file from source path [$($deployed.sourcePath)]"
    Remove-Item -Force $deployed.sourcePath
}

If ($deployed.destinationPath -ne $deployed.sourcePath) {
    Write-Output "Removing assembly file from destination path [$($deployed.destinationPath)]"
    Remove-Item -Force $deployed.destinationPath
}
