Function LoadBizTalkSnapIn() {
    Write-Output "Loading BizTalk Snap-In"
    $InitializeDefaultBTSDrive = $false
    Add-PSSnapin -Name BizTalkFactory.PowerShell.Extensions
}

Function ConnectToBizTalkDatabase($bizTalkServer) {
    LoadBizTalkSnapIn

    Write-Output "Connecting to BizTalk database [$($bizTalkServer.databaseName)] on [$($bizTalkServer.instanceName)]"
    $psdrive = New-PSDrive -Name "BizTalk4Deployit" -PSProvider BizTalk -Root "BizTalk4Deployit:\" -Instance $bizTalkServer.instanceName -Database $bizTalkServer.databaseName -Scope Script
}
