ConnectToBizTalkDatabase $deployed.container

If ($deployed.sourcePath) {
    Write-Output "Copying assembly to source path [$($deployed.sourcePath)]"
    Copy-Item -Force $deployed.file $deployed.sourcePath
    $sourcePath = $deployed.sourcePath
} Else {
    $sourcePath = $deployed.file
}

If ($deployed.destinationPath -ne $deployed.sourcePath) {
    Write-Output "Copying assembly to destination path [$($deployed.destinationPath)]"
    Copy-Item -Force $deployed.file $deployed.destinationPath
}

Write-Output "Adding assembly [$($deployed.name)] to BizTalk application [$($deployed.applicationName)]"
cd "BizTalk4Deployit:\Applications\$($deployed.applicationName)\Resources"
$expr = '$assembly = New-Item -Path $deployed.name -Source $sourcePath -ItemType $deployed.assemblyType -DestinationLocation $deployed.destinationPath'
if($deployed.gacOnAdd) {
	$expr += " -GacOnAdd"
}
if($deployed.gacOnImport) {
	$expr += " -GacOnImport"
}
if($deployed.gacOnInstall) {
	$expr += " -GacOnInstall"
}
if($deployed.overwrite) {
	$expr += " -Overwrite"
}
if($deployed.regAsm) {
	$expr += " -Regasm"
}
if($deployed.regSvcs) {
	$expr += " -Regsvcs"
}
Invoke-Expression $expr
