#!/usr/bin/python

import bigsuds as pc

bigip_address = '${container.address}'
bigip_user = '${container.username}'
bigip_pass = '${container.password}'
active_partition = '${container.partition}'
poolmember_pool = '${poolmember.bigIpPool}'
poolmember_address = '${poolmember.bigIpAddress}'
poolmember_port = '${poolmember.bigIpPort}'

print 'Connecting to BIG-IP at [' + bigip_address + '] as user [' + bigip_user + ']'
bigip = pc.BIGIP(hostname=bigip_address, username=bigip_user, password=bigip_pass)

pool = bigip.LocalLB.Pool
pool_version = pool.get_version()
print 'Detected version: ' + pool_version

print 'Setting active partition to [' + active_partition + ']'
bigip.Management.Partition.set_active_partition(active_partition)

# session state
print 'Disabling pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + ']'
bigip.LocalLB.PoolMember.set_monitor_state([poolmember_pool], [
[{'member': {'address': poolmember_address, 'port': poolmember_port}, 'monitor_state': 'STATE_DISABLED'}]])

# monitor state
print 'Forcing pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + '] offline'
bigip.LocalLB.PoolMember.set_session_enabled_state([poolmember_pool], [
[{'member': {'address': poolmember_address, 'port': poolmember_port}, 'session_state': 'STATE_DISABLED'}]])

print 'Done'
