/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.ContainerContributor;
import com.xebialabs.deployit.plugin.lb.util.DeploymentGroups;
import com.xebialabs.deployit.plugin.lb.util.Environments;
import com.xebialabs.deployit.plugin.lb.util.LoadBalancedContainers;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageLoadBalancerPools
extends ContainerContributor<Container> {
    private static final Type LOADBALANCER_TYPE = Type.valueOf(LoadBalancer.class);
    private static final Logger logger = LoggerFactory.getLogger(ManageLoadBalancerPools.class);

    public ManageLoadBalancerPools() {
        super(Container.class);
    }

    @Contributor
    public void manageContainersInPool(Deltas deltas, DeploymentPlanningContext ctx) {
        this.collectContainers(deltas);
        Environment targetEnvironment = ctx.getDeployedApplication().getEnvironment();
        Set<LoadBalancer> loadBalancers = Environments.getMembersOfType(targetEnvironment, LOADBALANCER_TYPE);
        if (loadBalancers.isEmpty()) {
            logger.debug("No load balancers in environment. Nothing to do.");
            return;
        }
        Integer currentDeploymentGroup = this.getCurrentDeploymentGroup(this.containers);
        if (currentDeploymentGroup == null) {
            logger.info("Unable to determine deployment group for containers: %s. Will not add steps.", (Object)this.containers);
            return;
        }
        ListMultimap<Container, LoadBalancer> containerLoadBalancers = LoadBalancedContainers.getContainerLoadBalancers(loadBalancers);
        Map<Container, LoadBalancedContainers.LoadBalancingBounds> containerBalancingBounds = LoadBalancedContainers.getLoadBalancingBounds(containerLoadBalancers.keySet());
        HashMultimap stopTrafficNowOn = HashMultimap.create();
        HashMultimap startTrafficNowOn = HashMultimap.create();
        for (Map.Entry<Container, LoadBalancedContainers.LoadBalancingBounds> balancingBounds : containerBalancingBounds.entrySet()) {
            Container container = balancingBounds.getKey();
            LoadBalancedContainers.LoadBalancingBounds bounds = balancingBounds.getValue();
            List balancers = containerLoadBalancers.get((Object)container);
            if (bounds.startGroup == currentDeploymentGroup) {
                this.addBalancedContainers((Multimap<LoadBalancer, Container>)stopTrafficNowOn, balancers, container);
            }
            if (bounds.endGroup != currentDeploymentGroup) continue;
            this.addBalancedContainers((Multimap<LoadBalancer, Container>)startTrafficNowOn, balancers, container);
        }
        for (LoadBalancer loadBalancer : stopTrafficNowOn.keySet()) {
            Set serversToDisable = stopTrafficNowOn.get((Object)loadBalancer);
            logger.debug("Deployment group [{}]: Adding steps to *stop* traffic to [{}] on loadbalancer [{}]", new Object[]{currentDeploymentGroup, serversToDisable, loadBalancer});
            loadBalancer.stopTraffic(ctx, serversToDisable);
        }
        for (LoadBalancer loadBalancer : startTrafficNowOn.keySet()) {
            Set serversToEnable = startTrafficNowOn.get((Object)loadBalancer);
            logger.debug("Deployment group [{}]: Adding steps to *start* traffic to [{}] on loadbalancer [{}]", new Object[]{currentDeploymentGroup, serversToEnable, loadBalancer});
            loadBalancer.startTraffic(ctx, serversToEnable);
        }
    }

    private void addBalancedContainers(Multimap<LoadBalancer, Container> balancerToContainers, List<LoadBalancer> balancers, Container container) {
        for (LoadBalancer balancer : balancers) {
            balancerToContainers.put((Object)balancer, (Object)container);
        }
    }

    private Integer getCurrentDeploymentGroup(Set<Container> containers) {
        if (!containers.isEmpty()) {
            return DeploymentGroups.getDeploymentGroup(containers.iterator().next());
        }
        return null;
    }
}

