/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Serializable;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@StepMetadata(name="wait")
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011\u0001bV1jiN#X\r\u001d\u0006\u0003\u0007\u0011\tQa\u001d;faNT!!\u0002\u0004\u0002\rAdWoZ5o\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t\u0011b]1uK2d\u0017\u000e^3\u000b\u0005mA\u0011A\u0003=ma2\fGOZ8s[&\u0011Q\u0004\u0007\u0002\u000f'\u0006$X\r\u001c7ji\u0016\fu/\u0019:f\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013!C:uKB|%\u000fZ3s!\ty\u0011%\u0003\u0002#!\t9\u0011J\u001c;fO\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u001fM$X\r\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"AJ\u0018\u000f\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\r\u0003\u0019a$o\\8u})\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u0003!\u0003E9\u0018-\u001b;US6,\u0017J\\*fG>tGm\u001d\u0005\u0006k\u0001!\tAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]J$h\u000f\t\u0003q\u0001i\u0011A\u0001\u0005\u0006?Q\u0002\r\u0001\t\u0005\u0006IQ\u0002\r!\n\u0005\u0006gQ\u0002\r\u0001\t\u0005\u0006k\u0001!\t!\u0010\u000b\u0002o!)Q\u0007\u0001C\u0001\u007fQ)q\u0007Q!C\u0007\")qD\u0010a\u0001A!)AE\u0010a\u0001K!)1G\u0010a\u0001A!)AI\u0010a\u0001\u000b\u0006!\u0001n\\:u!\t1\u0015*D\u0001H\u0015\tAE!A\u0005pm\u0016\u0014H\u000f[3sK&\u0011!j\u0012\u0002\u0005\u0011>\u001cH\u000fC\u0004M\u0001\t\u0007IQB'\u0002!M+5i\u0014(E'~#vjX*M\u000b\u0016\u0003V#\u0001(\u0010\u0003=k\u0012A\u0003\u0005\u0007#\u0002\u0001\u000bQ\u0002(\u0002#M+5i\u0014(E'~#vjX*M\u000b\u0016\u0003\u0006\u0005C\u0004T\u0001\t\u0007I\u0011\u0002+\u0002\u000fM,7m\u001c8egV\t\u0001\u0005\u0003\u0004W\u0001\u0001\u0006I\u0001I\u0001\tg\u0016\u001cwN\u001c3tA!\"Q\u000b\u00171b!\tIf,D\u0001[\u0015\tYF,A\u0003sk2,7O\u0003\u0002^\t\u0005\u0019\u0011\r]5\n\u0005}S&!D*uKB\u0004\u0016M]1nKR,'/A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u00012\u0002WM+7m\u001c8eg\u0002\"\b.\u0019;!i\"L7\u000fI:uKB\u0004\u0003/Y;tK\u0002\u0002H.\u00198!Kb,7-\u001e;j_:Dq\u0001\u0019\u0001A\u0002\u0013%A-F\u0001&\u0011\u001d1\u0007\u00011A\u0005\n\u001d\fq\u0002Z3tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0003Q2\u0004\"!\u001b6\u000e\u0003-J!a[\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b[\u0016\f\t\u00111\u0001&\u0003\rAH%\r\u0005\u0007_\u0002\u0001\u000b\u0015B\u0013\u0002\u0019\u0011,7o\u0019:jaRLwN\u001c\u0011)\r9D\u0006-]:uC\u0005\u0011\u0018a\u0013#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004sN\u001a\u0011uQ&\u001c\be\u001d;fa2\u0002\u0013m\u001d\u0011ji\u0002\u001a\bn\\;mI\u0002\n\u0007\u000f]3be\u0002Jg\u000eI4f]\u0016\u0014\u0018\r^3eA\u0011,\u0007\u000f\\8z[\u0016tG\u000f\t9mC:\u001c\u0018AC2bY\u000e,H.\u0019;fIf\t\u0011\u0001C\u0004w\u0001\t\u0007I\u0011\u0002+\u0002\u000b=\u0014H-\u001a:\t\ra\u0004\u0001\u0015!\u0003!\u0003\u0019y'\u000fZ3sA!\"q\u000f\u00171{C\u0005Y\u0018aG#yK\u000e,H/[8oA=\u0014H-\u001a:!_\u001a\u0004C\u000f[3!gR,\u0007\u000fC\u0005~\u0001\u0001\u0007\t\u0019!C\u0005}\u0006I1m\u001c8uC&tWM]\u000b\u0002\u007fB\u0019a)!\u0001\n\u0007\u0005\rqIA\u0007I_N$8i\u001c8uC&tWM\u001d\u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0013\tI!A\u0007d_:$\u0018-\u001b8fe~#S-\u001d\u000b\u0004Q\u0006-\u0001\u0002C7\u0002\u0006\u0005\u0005\t\u0019A@\t\u000f\u0005=\u0001\u0001)Q\u0005\u007f\u0006Q1m\u001c8uC&tWM\u001d\u0011\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005yAm\u001c)pgR\u001cuN\\:ueV\u001cG\u000fF\u0002i\u0003/A\u0001\"!\u0007\u0002\u0012\u0001\u0007\u00111D\u0001\u0004GRD\bcA-\u0002\u001e%\u0019\u0011q\u0004.\u00031M#X\r\u001d)pgR\u001cuN\\:ueV\u001cGoQ8oi\u0016DH\u000f\u000b\u0003\u0002\u0012\u0005\r\u0002cA-\u0002&%\u0019\u0011q\u0005.\u0003#I+H.\u001a)pgR\u001cuN\\:ueV\u001cG\u000fC\u0004\u0002,\u0001!\t%!\f\u0002\u0011\u001d,Go\u0014:eKJ$\"!a\f\u0011\u0007%\f\t$C\u0002\u00024-\u00121!\u00138u\u0011\u001d\t9\u0004\u0001C!\u0003s\tabZ3u\t\u0016\u001c8M]5qi&|g\u000eF\u0001&\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tq!\u001a=fGV$X\r\u0006\u0003\u0002B\u00055\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC,\u0001\u0003gY><\u0018\u0002BA&\u0003\u000b\u0012Ab\u0015;fa\u0016C\u0018\u000e^\"pI\u0016D\u0001\"!\u0007\u0002<\u0001\u0007\u0011q\n\t\u0005\u0003\u0007\n\t&\u0003\u0003\u0002T\u0005\u0015#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t9\u0006\u0001C!\u00033\nAbZ3u'\u0006$X\r\u001c7ji\u0016$\"!a\u0017\u0011\u0007]\ti&C\u0002\u0002`a\u0011\u0011bU1uK2d\u0017\u000e^3)\u000f\u0001\t\u0019'!\u001b\u0002lA\u0019\u0011,!\u001a\n\u0007\u0005\u001d$L\u0001\u0007Ti\u0016\u0004X*\u001a;bI\u0006$\u0018-\u0001\u0003oC6,\u0017EAA7\u0003\u00119\u0018-\u001b;")
public class WaitStep
implements SatelliteAware {
    @StepParameter(description="Seconds that this step pause plan execution")
    private final Integer seconds;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans", calculated=true)
    private String description;
    @StepParameter(description="Execution order of the step")
    private final Integer order;
    private HostContainer container;

    private final int SECONDS_TO_SLEEP() {
        return 10;
    }

    private Integer seconds() {
        return this.seconds;
    }

    private String description() {
        return this.description;
    }

    private void description_$eq(String x$1) {
        this.description = x$1;
    }

    private Integer order() {
        return this.order;
    }

    private HostContainer container() {
        return this.container;
    }

    private void container_$eq(HostContainer x$1) {
        this.container = x$1;
    }

    @RulePostConstruct
    private void doPostConstruct(StepPostConstructContext ctx) {
        block0: {
            if (this.description() != null && this.description().length() != 0) break block0;
            this.description_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.seconds()})));
        }
    }

    public int getOrder() {
        return Predef$.MODULE$.Integer2int(this.order());
    }

    public String getDescription() {
        return this.description();
    }

    public StepExitCode execute(ExecutionContext ctx) {
        int sleepIntervals = Predef$.MODULE$.Integer2int(this.seconds()) / 10;
        int remainingSeconds = Predef$.MODULE$.Integer2int(this.seconds()) % 10;
        ctx.logOutput(this.getDescription());
        try {
            ObjectRef secondsCountDown = ObjectRef.create((Object)this.seconds());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sleepIntervals).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                ctx.logOutput(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time remaining ", " seconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Integer)secondsCountDown$1.elem})));
                Thread.sleep(10000L);
                secondsCountDown$1.elem = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)secondsCountDown$1.elem) - 10);
            });
            if (remainingSeconds > 0) {
                ctx.logOutput(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time remaining ", " seconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)remainingSeconds)})));
                Thread.sleep(remainingSeconds * 1000);
            }
            ctx.logOutput("Wait complete.");
        }
        catch (InterruptedException i) {
            ctx.logOutput("Wait interrupted.");
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.SUCCESS;
    }

    public Satellite getSatellite() {
        return (Satellite)Option$.MODULE$.apply((Object)this.container()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHost().getSatellite()).orNull(Predef$.MODULE$.$conforms());
    }

    public WaitStep(Integer stepOrder, String stepDescription, Integer waitTimeInSeconds) {
        this.seconds = waitTimeInSeconds;
        this.description = stepDescription;
        this.order = stepOrder;
    }

    public WaitStep() {
        this(null, null, null);
    }

    public WaitStep(Integer stepOrder, String stepDescription, Integer waitTimeInSeconds, Host host) {
        this(stepOrder, stepDescription, waitTimeInSeconds);
        this.container_$eq((HostContainer)host);
    }
}

