package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Preview, PreviewStep, StepExitCode}
import com.xebialabs.deployit.plugin.api.rules.{StepMetadata, StepParameter}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.beans.BeanProperty

@StepMetadata(name = "create-ci")
class CreateCiStep extends BaseStep with PreviewStep {

  @StepParameter(description = "Configuration item to create", required = true)
  @BeanProperty var ci: ConfigurationItem = null

  override def getPreview: Preview = Preview.withContents(s"creating ci ${ci.getType} with id ${ci.getId}")

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput(s"Creating ${ci.getType} with id ${ci.getId}")
    ctx.getRepository.create(ci)
    StepExitCode.SUCCESS
  }


}
