package com.xebialabs.deployit.plugin.steps

import java.util.{Collections, HashMap => JHashMap, Map => JMap}

import com.xebialabs.deployit.plugin.api.rules.{Scope, StepPostConstructContext}

import scala.collection.convert.wrapAsJava._
import scala.collection.convert.wrapAsScala._

object ContextHelper {

  def defaultContext(ctx: StepPostConstructContext, addEntries: JMap[String, Any] = Collections.emptyMap()): JMap[String, Any] = {
    val default: Map[String, Any] = ctx.getScope match {
      case Scope.DEPLOYED => Map("deployed" -> ctx.getDelta.getDeployed, "previousDeployed" -> ctx.getDelta.getPrevious)
      case _ => Map.empty
    }
    new JHashMap(default ++ Option(addEntries).getOrElse(new JHashMap[String, Any]()))
  }
}
