package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow._
import com.xebialabs.deployit.plugin.api.rules.{RulePostConstruct, StepMetadata, StepParameter, StepPostConstructContext}
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact
import com.xebialabs.deployit.plugin.overthere.Host
import com.xebialabs.xlplatform.satellite.{Satellite, SatelliteAware}

@StepMetadata(name = "upload")
class UploadStep(artifactToCopy: Artifact, path: String, host: Host, createPath: Boolean = true)
  extends BaseStep with TargetHostSupport with StageableStep with CopyFileSupport with SatelliteAware {

  def this() = this(null, null, null)

  targetHost = host
  targetPath = path
  createTargetPath = createPath

  private var stagedFile: StagedFile = _

  @StepParameter(description = "Whether to create the target folder structure if not present. Defaults to true", required = false)
  private[steps] var createTargetPath: Boolean = _

  @StepParameter(description = "Full path on the target host where the artifact is copied")
  private[steps] var targetPath: String = _

  @StepParameter(description = "Artifact that is uploaded to the target host", calculated = true)
  private[steps] var artifact = artifactToCopy

  @RulePostConstruct
  protected def calculateParameters(ctx: StepPostConstructContext) = {
    calculateOrder(ctx)
    calculateDescription(ctx)
    calculateTargetHost(ctx)
    artifact = Option(artifact).getOrElse(ArtifactHelper.defaultArtifact(ctx))
  }

  override def requestStaging(ctx: StagingContext): Unit = stagedFile = ctx.stageArtifact(artifact, targetHost)

  override protected[steps] def executeOnTargetHost(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): StepExitCode = {
    try {
      val targetFile = remoteFile(targetPath)
      mkTargetDirsIfRequired(targetFile, createTargetPath)
      deleteTargetFileIfPresent(targetFile)
      copyFileToTarget(stagedFile.get(targetHostEnvironment.connection, ctx), targetFile)
      StepExitCode.SUCCESS
    } catch {
      case ExitStep => StepExitCode.FAIL
    }
  }

  override def getSatellite: Satellite = {
    targetHost.getSatellite
  }
}
