package com.xebialabs.deployit.plugin.delegates

import java.util.{List => JList}
import java.util.{Map => JMap}

import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.deployit.plugin.steps.JythonStep
import collection.convert.wrapAll._

object JythonDelegate {

  val DEFAULT_CONTROL_TASK_STEP_ORDER = 1

  @Delegate(name = "jythonScript")
  def jythonScriptDelegate(item: ConfigurationItem, name: String, args: JMap[String, String], params: Parameters): JList[Step] = {
    require(args.containsKey("script"), s"No script defined for control task [$name] of [$item].")
    val script: String = args("script")
    val step: JythonStep = new JythonStep
    step.setOrder(DEFAULT_CONTROL_TASK_STEP_ORDER)
    step.setScriptPath(script)
    if (args.containsKey("description")) {
      step.setDescription(args.get("description"))
    } else {
      step.setDescription(s"Executing control task $name on ${item.getId}")
    }
    step.getJythonContext.put("params", params)
    step.getJythonContext.put("args", args)
    step.getJythonContext.put("thisCi", item)
    List(step)
  }
}
