package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.deployment.specification.Operation
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.rules.{Scope, StepParameter, StepPostConstructContext}
import com.xebialabs.deployit.plugin.api.udm.Container
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact
import com.xebialabs.xlplatform._

object OrderHelper {

  def defaultOrder(ctx: StepPostConstructContext) = Option(ctx.getDelta).map(_.getOperation) match {
    case Some(Operation.DESTROY) => if (ctx.getDelta.getPrevious.isInstanceOf[Artifact]) 30 else 40
    case Some(_) => if (ctx.getDelta.getDeployed.isInstanceOf[Artifact]) 70 else 60
    case None => 50
  }
}

object DescriptionHelper {
  def defaultDescription(ctx: StepPostConstructContext) = ctx.getScope match {
    case Scope.DEPLOYED =>
      val deployed = ctx.getDelta.correctDeployed
      s"${operationToVerb(ctx.getDelta.getOperation)} ${deployed.getName} on ${deployed.getContainer.asInstanceOf[Container].getName}"
    case _ => null
  }

  private def operationToVerb(op: Operation) = op match {
    case Operation.CREATE => "Create"
    case Operation.DESTROY => "Delete"
    case Operation.MODIFY | Operation.NOOP => "Update"
  }
}

trait BaseStep extends Step {

  @StepParameter(description = "Description of this step, as it should appear in generated deployment plans", calculated = true)
  protected var description: String = null

  @StepParameter(description = "Execution order of the step", calculated = true)
  protected var order: Integer = null

  def calculateOrder(ctx: StepPostConstructContext) = {
    order = Option(order).getOrElse(OrderHelper.defaultOrder(ctx))
  }

  def calculateDescription(ctx: StepPostConstructContext) = {
    if (description == null || description.isEmpty) {
      description = DescriptionHelper.defaultDescription(ctx)
    }
  }

  def getOrder: Int = order

  def getDescription: String = description

  def setOrder(o: Int): Unit = {
    order = o
  }

  def setDescription(d: String): Unit = {
    description = d
  }
}
