package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import freemarker.template.{DefaultObjectWrapper, TemplateModel}


class BaseCiAwareObjectWrapper(private[freemarker] val maskPasswords: Boolean) extends DefaultObjectWrapper {

  override def wrap(obj: scala.Any): TemplateModel = obj match {
    case ci: ConfigurationItem => new CiTemplateModel(ci, this)
    case other@_ => super.wrap(other)
  }
}
