package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow._
import com.xebialabs.deployit.plugin.api.rules.{StepParameter, StepMetadata}

@StepMetadata(name = "noop")
class NoopStep extends Step with PreviewStep {

  @StepParameter(description = "Description of this step, as it should appear in generated deployment plans", calculated = false)
  private val description: String = null

  @StepParameter(description = "Execution order of the step", calculated = false)
  private val order: Integer = null

  override def getOrder: Int = order

  override def getDescription: String = description

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput(s"This step does not perform any actions.")
    StepExitCode.SUCCESS
  }

  override def getPreview: Preview = Preview.withContents("This step does not perform any actions.")
}
