package com.xebialabs.deployit.plugin.freemarker

import java.util

import grizzled.slf4j.Logging

object ResolverForJava extends Logging {

  import scala.collection.convert.wrapAll._

  def resolveJavaMapExpressions(expressions: util.Map[String, String], context: util.Map[String, AnyRef]): util.Map[String, String] = {
    Resolver.resolveMapExpressions(expressions.toMap, context.toMap)
  }

  def resolveJavaListExpressions(expressions: util.List[String], context: AnyRef): util.List[String] = {
    Resolver.transformCollectionByResolvingExpression(expressions, context).toSeq
  }

  def resolveJavaSetExpressions(expressions: util.Set[String], context: AnyRef): util.Set[String] = {
    setAsJavaSet(Resolver.transformCollectionByResolvingExpression(expressions, context).toSet)
  }

}
