package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.base.{BaseContainer, BaseDeployed}
import com.xebialabs.deployit.plugin.freemarker.Resolver.{resolveExpression, resolveExpressions, resolveMapExpressions}
import freemarker.ext.beans.BeanModel
import freemarker.template.TemplateModel

import scala.collection.convert.wrapAll._


class CiTemplateModel(ci: ConfigurationItem, wrapper: CiAwareObjectWrapper, maskPasswords: Boolean) extends BeanModel(ci, wrapper) {

  private val MASKED_PASSWORD: String = "********"

  override def get(key: String): TemplateModel = {
    val pd = ci.getType.getDescriptor.getPropertyDescriptor(key)
    if (pd == null) {
      super.get(key)
    } else {
      wrapper.wrap(extractValueFromCi(pd))
    }
  }

  private def extractValueFromCi(pd: PropertyDescriptor): AnyRef = {

    val ctx: Map[String, AnyRef] = ci match {
      case _: BaseDeployed[_, _] => Map("deployed" -> ci)
      case _: BaseContainer => Map("container" -> ci)
      case _ => Map[String, AnyRef]()
    }

    if (pd.isPassword && maskPasswords) {
      pd.getKind match {
        case PropertyKind.SET_OF_STRING => return setAsJavaSet(Set(MASKED_PASSWORD))
        case PropertyKind.LIST_OF_STRING => return seqAsJavaList(Seq(MASKED_PASSWORD))
        case PropertyKind.MAP_STRING_STRING => return mapAsJavaMap(Map(MASKED_PASSWORD -> MASKED_PASSWORD))
        case _ => return MASKED_PASSWORD
      }
    }

    pd.getKind match {
      case PropertyKind.STRING => resolveExpression(pd.get(ci).asInstanceOf[String], ctx);
      case PropertyKind.SET_OF_STRING => asJavaCollection(resolveExpressions(any2Iterable(pd.get(ci)), ctx))
      case PropertyKind.LIST_OF_STRING => asJavaCollection(resolveExpressions(any2Iterable(pd.get(ci)), ctx))
      case PropertyKind.MAP_STRING_STRING => mapAsJavaMap(resolveMapExpressions(any2Map(pd.get(ci)), ctx))
      case _ => pd.get(ci)
    }
  }

  override def isEmpty: Boolean = false
}
