/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.AbstractApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.ApacheVirtualHostDefinition;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CreateApacheHttpdVirtualHostStep
extends AbstractApacheHttpdServerStep {
    private String virtualHost;
    private Collection<? extends Object> context;

    public CreateApacheHttpdVirtualHostStep(ApacheHttpdServer apacheWebServer, String virtualHost, Collection<?> context) {
        super(apacheWebServer);
        if (StringUtils.isEmpty((String)virtualHost)) {
            throw new IllegalArgumentException("The virtual host definition cannot be empty");
        }
        this.virtualHost = virtualHost;
        this.context = context;
        this.setDescription("Create Apache HTTP Server virtualhost " + virtualHost + " on host " + apacheWebServer.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.apacheHttpdServer.connectToAdminHost();
        ApacheVirtualHostDefinition definition = this.getApacheVirtualHostDefinition();
        try {
            String configLocationWrite = this.apacheHttpdServer.getConfigurationLocation();
            HostFile configLocationWriteFile = hostSession.getFile(configLocationWrite);
            String configFileWritePath = configLocationWriteFile.isDirectory() ? configLocationWrite + hostSession.getHostOperatingSystem().getFileSeparator() + definition.getFileName() : configLocationWrite;
            ctx.logOutput("Creating Apache HTTPD VirtualHost configuration file at " + configFileWritePath);
            HostFile vhostConfFile = hostSession.getFile(configFileWritePath);
            String virtualHostDefinition = definition.toVirtualHostDefinition();
            vhostConfFile.put(IOUtils.toInputStream((String)virtualHostDefinition), (long)virtualHostDefinition.length());
            HostFile documentRootPath = hostSession.getFile(definition.getDocumentRoot());
            if (!documentRootPath.exists()) {
                ctx.logOutput("Creating Apache HTTPD document root at " + documentRootPath);
                documentRootPath.mkdir();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }

    protected ApacheVirtualHostDefinition getApacheVirtualHostDefinition() {
        ApacheVirtualHostDefinition definition = new ApacheVirtualHostDefinition(this.getDeployedOnVhostDefinition(), this.apacheHttpdServer.getHtdocsLocation(), this.apacheHttpdServer.getHost().getOperatingSystemFamily(), this.context);
        return definition;
    }

    public String getDeployedOnVhostDefinition() {
        return this.virtualHost;
    }

    public void setDeployedOnVhostDefinition(String deployedOnVhostDefinition) {
        this.virtualHost = deployedOnVhostDefinition;
    }

    public Collection<?> getContext() {
        return this.context;
    }
}

