/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.dictionary;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.dictionary.ci.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoFiller {
    protected final Deployment deployment;
    private static Logger logger = Logger.getLogger(AutoFiller.class);

    public AutoFiller(Deployment deployment) {
        this.deployment = deployment;
    }

    public void process(List<KeyValuePair> keyValuePairs) {
        Application application = this.deployment.getSource().getApplication();
        Environment environment = this.deployment.getTarget();
        logger.debug((Object)("input kvp " + keyValuePairs));
        Map<String, String> flattenKeyValuePairs = this.getAvailableDictionary(this.deployment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("available key value pair: " + flattenKeyValuePairs));
        }
        for (KeyValuePair actualEntry : keyValuePairs) {
            if (StringUtils.isNotBlank((String)actualEntry.getValue())) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("already overridden property for key " + actualEntry.getKey() + " -> " + actualEntry.getValue()));
                continue;
            }
            String value = this.findMatchingValue(actualEntry.getKey(), flattenKeyValuePairs, application, environment);
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("resolved property for key " + actualEntry.getKey() + " -> " + value));
            }
            actualEntry.setValue(value);
        }
    }

    private String findMatchingValue(String key, Map<String, String> flattenKeyValuePairs, Application application, Environment environment) {
        String envName = StringUtils.substringAfterLast((String)environment.getLabel(), (String)"/");
        String envKey = envName.toLowerCase() + "." + key;
        logger.debug((Object)("envKey " + envKey));
        String appName = StringUtils.substringAfterLast((String)application.getLabel(), (String)"/");
        String appKey = appName.toLowerCase() + "." + key;
        logger.debug((Object)("appKey " + appKey));
        String appEnvKey = appName.toLowerCase() + "." + envName.toLowerCase() + "." + key;
        logger.debug((Object)("appEnvKey " + appEnvKey));
        if (flattenKeyValuePairs.containsKey(appEnvKey)) {
            return flattenKeyValuePairs.get(appEnvKey);
        }
        if (flattenKeyValuePairs.containsKey(envKey)) {
            return flattenKeyValuePairs.get(envKey);
        }
        if (flattenKeyValuePairs.containsKey(appKey)) {
            return flattenKeyValuePairs.get(appKey);
        }
        if (flattenKeyValuePairs.containsKey(key)) {
            return flattenKeyValuePairs.get(key);
        }
        return null;
    }

    protected Map<String, String> getAvailableDictionary(Deployment deployment) {
        HashMap result = Maps.newHashMap();
        Environment env = deployment.getTarget();
        Set membersOfType = env.getMembersOfType(Dictionary.class);
        for (Dictionary d : membersOfType) {
            result.putAll(KeyValuePair.toMap(d.getKeyValuePairs()));
        }
        return result;
    }
}

