package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * This step pauses a single time, by returning false. By contract, this means that the task which executes this step is halted
 * at that specific step. Upon continuing the task, the step will succeed because it maintains its own state.
 */
public class SinglePauseStep implements Step {
    private AtomicBoolean pass = new AtomicBoolean(false);

    public String getDescription() {
        return "Pauses the executing deployment a single time, once the deployment continues this step will pass.";
    }

    public boolean execute(StepExecutionContext ctx) {
        ctx.logOutput("Passing the Pause? " + pass.get());
        return pass.getAndSet(true);
    }
}
