/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.mapper.artifact;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.Hosted;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.artifact.mapping.FolderMapping;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Mapper that maps {@link com.xebialabs.deployit.ci.artifact.Folder} CI's to {@link com.xebialabs.deployit.ci.Host hosts} with {@link com.xebialabs.deployit.ci.artifact.mapping.FolderMapping} CI's.
 */
public class FolderToHostMapper<S extends Folder, M extends FolderMapping<? super S, ? super T>, T extends Hosted> extends StepGeneratingMapper<S, M, T> {

	public FolderToHostMapper(Change<Deployment> change) {
		super(change, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(S newSource, M m, T newMappingTarget, List<Step> steps) {
		generateAdditionStepsForAddedMapping(m, newMappingTarget.getHost(), steps);
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(S oldSource, M m, T oldMappingTarget, List<Step> steps) {
		generateDeletionStepsForDeletedMapping(m, oldMappingTarget.getHost(), steps);
	}

	protected void generateAdditionStepsForAddedMapping(FolderMapping<?,?> folderMapping, Host host, List<Step> steps) {
		if (StringUtils.isBlank(folderMapping.getTargetDirectory())) {
			throw new ResolutionException("Target directory not specified for mapping " + folderMapping);
		}
		final Folder sourceFolder = (Folder) folderMapping.getSource();
		final Map<String, String> propertyMap = KeyValuePair.toMap(folderMapping.getKeyValuePairs());
		final PlaceholderFormat placeholderFormat = folderMapping.getPlaceholderFormat();
		final CopyStep step = new CopyStep(Host.getLocalHost(), sourceFolder.getLocation(), host, folderMapping.getTargetDirectory(),
				propertyMap, placeholderFormat);
		step.setCreateToplevelDirectory(folderMapping.isCreateIfNotExist());
		step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
		steps.add(step);
	}


	protected void generateDeletionStepsForDeletedMapping(FolderMapping<?,?> folderMapping, Host host, List<Step> steps) {
		final Folder sourceFolder = (Folder) folderMapping.getSource();
		if (!folderMapping.isShared()) {
			final DeleteStep step = new DeleteStep(host, folderMapping.getTargetDirectory());
			step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
			steps.add(step);
		} else {
			for (File f : sourceFolder.getFiles()) {
				String fileToDelete = new File(folderMapping.getTargetDirectory(), f.getName()).getPath();
				final DeleteStep step = new DeleteStep(host, fileToDelete);
				step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
				steps.add(step);
			}
		}
	}


}
