/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLine {
    List<CmdLineArgument> arguments = Lists.newArrayList();

    public CmdLine addArgument(String arg) {
        this.arguments.add(CmdLineArgument.arg(arg));
        return this;
    }

    public CmdLine addPassword(String arg) {
        this.arguments.add(CmdLineArgument.password(arg));
        return this;
    }

    public CmdLine add(CmdLineArgument arg) {
        this.arguments.add(arg);
        return this;
    }

    public List<CmdLineArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String[] toCommandLine(final boolean forLogging) {
        return Lists.transform(this.arguments, (Function)new Function<CmdLineArgument, String>(){

            public String apply(CmdLineArgument from) {
                return from.toString(forLogging);
            }
        }).toArray(new String[this.arguments.size()]);
    }

    public static CmdLine asCommandLine(String ... cmdarray) {
        CmdLine cmdLine = new CmdLine();
        boolean seenPassword = false;
        for (String s : cmdarray) {
            if (seenPassword) {
                cmdLine.addPassword(s);
            } else {
                cmdLine.addArgument(s);
            }
            seenPassword = StringUtils.endsWithIgnoreCase((String)s, (String)"password");
        }
        return cmdLine;
    }
}

