/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.cifs;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public class CifsHostFile
extends AbstractHostFile {
    private SmbFile smbFile;

    CifsHostFile(HostSession session, SmbFile smbFile) {
        super(session);
        this.smbFile = smbFile;
    }

    SmbFile getSmbFile() {
        return this.smbFile;
    }

    @Override
    public String getName() {
        return this.smbFile.getName();
    }

    @Override
    public String getParent() {
        return this.smbFile.getParent();
    }

    @Override
    public String getPath() {
        String uncPath = this.smbFile.getUncPath();
        int slashPos = uncPath.indexOf(92, 2);
        String drive = uncPath.substring(slashPos + 1, slashPos + 2);
        String path = uncPath.substring(slashPos + 3);
        return drive + ":" + path;
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        try {
            return this.smbFile.exists();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine existence of " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is a directory" + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be executed" + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be read" + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be written" + ": " + exc.toString(), exc);
        }
    }

    @Override
    public long length() throws RuntimeIOException {
        try {
            return this.smbFile.length();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot determine length of file " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        try {
            this.upgradeToDirectorySmbFile();
            return Arrays.asList(this.smbFile.list());
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        try {
            this.smbFile.mkdir();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot create directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        try {
            this.smbFile.mkdirs();
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot create directories " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void moveTo(HostFile destFile) throws RuntimeIOException {
        if (destFile instanceof CifsHostFile) {
            SmbFile targetSmbFile = ((CifsHostFile)destFile).getSmbFile();
            try {
                this.smbFile.renameTo(targetSmbFile);
            }
            catch (SmbException exc) {
                throw new RuntimeIOException("Cannot move/rename " + this + " to " + destFile + ": " + exc.toString(), exc);
            }
        } else {
            throw new RuntimeIOException("Cannot move/rename SMB file/directory " + this + " to non-SMB file/directory " + destFile);
        }
    }

    @Override
    public boolean delete() throws RuntimeIOException {
        try {
            if (this.smbFile.exists()) {
                if (this.smbFile.isDirectory()) {
                    this.upgradeToDirectorySmbFile();
                    String[] files = this.smbFile.list();
                    if (files.length != 0) {
                        throw new RuntimeIOException("Cannot delete non-empty directory " + this);
                    }
                }
                this.smbFile.delete();
                this.refreshSmbFile();
                return true;
            }
            return false;
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        try {
            if (this.smbFile.exists()) {
                if (this.smbFile.isDirectory()) {
                    this.upgradeToDirectorySmbFile();
                }
                this.smbFile.delete();
                this.refreshSmbFile();
                return true;
            }
            return true;
        }
        catch (MalformedURLException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (SmbException exc) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        try {
            return this.smbFile.getInputStream();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot read from file " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        try {
            return this.smbFile.getOutputStream();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot write to file " + this + ": " + exc.toString(), exc);
        }
    }

    private void upgradeToDirectorySmbFile() throws MalformedURLException {
        if (!this.smbFile.getPath().endsWith("/")) {
            this.smbFile = new SmbFile(this.smbFile.getURL() + "/");
        }
    }

    private void refreshSmbFile() throws MalformedURLException {
        this.smbFile = new SmbFile(this.smbFile.getPath());
    }

    public String toString() {
        return this.getPath() + " on " + this.session;
    }

    @Override
    protected int executeCommand(CommandExecutionCallbackHandler handler, CmdLine command) {
        return this.session.execute(handler, command);
    }
}

